/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.task;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.client.EasyPaymentsClient;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdates;
import ru.easydonate.easypayments.core.util.ThreadLocker;
import ru.easydonate.easypayments.core.util.ThrowableCauseFinder;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.ApiResponseFailureException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.service.IssuanceReportService;
import ru.easydonate.easypayments.service.LongPollEventDispatcher;
import ru.easydonate.easypayments.shopcart.ShopCartConfig;
import ru.easydonate.easypayments.task.AbstractPluginTask;

public final class PaymentsQueryTask
extends AbstractPluginTask {
    private static final Pattern RESPONSE_CODE_EXCEPTION = Pattern.compile("Server returned HTTP response code: (?<code>\\d+) for URL: (?<url>.+)");
    private static final String THREAD_NAME = "EasyPayments LongPoll Events Listener";
    private static final long TASK_PERIOD_MILLIS = 3000L;
    private final EasyPaymentsClient easyPaymentsClient;
    private final LongPollEventDispatcher eventDispatcher;
    private final IssuanceReportService reportService;
    private final ExecutorService longPollExecutor;
    private volatile boolean working;
    private Thread workingThread;
    private CompletableFuture<EventUpdates> longPollQueryTask;

    public PaymentsQueryTask(@NotNull EasyPaymentsPlugin plugin, @NotNull EasyPaymentsClient easyPaymentsClient, @NotNull LongPollEventDispatcher eventDispatcher, @NotNull IssuanceReportService reportService) {
        super(plugin, 100L);
        this.easyPaymentsClient = easyPaymentsClient;
        this.eventDispatcher = eventDispatcher;
        this.reportService = reportService;
        this.longPollExecutor = Executors.newSingleThreadExecutor();
    }

    @Override
    public boolean isWorking() {
        return this.working && this.workingThread != null && !this.workingThread.isInterrupted() && this.workingThread.isAlive();
    }

    @Override
    public void start() {
        this.working = true;
        this.workingThread = new Thread((Runnable)this, THREAD_NAME);
        this.workingThread.setDaemon(true);
        this.workingThread.start();
    }

    @Override
    public void shutdown() {
        if (this.workingThread == null) {
            return;
        }
        this.working = false;
        try {
            if (this.longPollQueryTask != null) {
                this.longPollQueryTask.cancel(true);
            }
            this.longPollExecutor.shutdownNow();
        }
        catch (Throwable ex) {
            this.plugin.getLogger().severe("Couldn't correctly shutdown a payments query task!");
            this.plugin.getLogger().severe(ex.getMessage());
        }
        ThreadLocker.doUninterruptive(() -> this.workingThread.join());
        this.workingThread = null;
    }

    @Override
    public void run() {
        ThreadLocker.lockUninterruptive(this.delay * 50L);
        while (this.isWorking()) {
            try {
                this.doQuery();
            }
            catch (CancellationException | RejectedExecutionException runtimeException) {
            }
            catch (Throwable ex) {
                this.plugin.getLogger().severe("An unexpected error was occurred!");
                this.plugin.getDebugLogger().error("An unexpected error was occurred!", new Object[0]);
                this.plugin.getDebugLogger().error(ex);
            }
            if (!this.isWorking()) continue;
            ThreadLocker.lockUninterruptive(3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() {
        if (this.longPollExecutor.isShutdown() || this.longPollExecutor.isTerminated()) {
            return;
        }
        try {
            this.longPollQueryTask = CompletableFuture.supplyAsync(this::queryUpdates, this.longPollExecutor);
            EventUpdates updates = (EventUpdates)((CompletableFuture)this.longPollQueryTask.exceptionally(throwable -> {
                if (throwable instanceof CancellationException || throwable instanceof RejectedExecutionException) {
                    return null;
                }
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof BadResponseException) {
                    BadResponseException cast = (BadResponseException)throwable;
                    this.warning(String.format("[PaymentsQuery] Bad response (%d) received from the API Server, waiting for 60 seconds...", cast.getHttpCode()));
                    this.plugin.getDebugLogger().warn("[PaymentsQuery] Bad response ({0}) received from the API Server, waiting for 60 seconds...", cast.getHttpCode());
                } else {
                    this.warning("[PaymentsQuery] Bad response received from the API Server, waiting for 60 seconds...");
                    this.plugin.getDebugLogger().warn("[PaymentsQuery] Bad response received from the API Server, waiting for 60 seconds...", new Object[0]);
                    if (throwable != null) {
                        this.plugin.getDebugLogger().warn((Throwable)throwable);
                    }
                }
                ThreadLocker.lockUninterruptive(60L, TimeUnit.SECONDS);
                return null;
            })).join();
            if (updates == null || updates.isEmpty()) {
                return;
            }
            this.plugin.getDebugLogger().debug("[PaymentsQuery] LongPoll API updates received:", new Object[0]);
            this.plugin.getDebugLogger().debug(updates.toPrettyString().split("\n"));
            DATABASE_QUERIES_LOCK.lock();
            try {
                ShopCartConfig shopCartConfig = this.plugin.getShopCartConfig();
                EventUpdateReports reports = this.eventDispatcher.processEventUpdates(updates).join();
                this.reportService.uploadReportsAndPersistStates(reports, payment -> {
                    if (payment == null || !payment.hasPurchases()) {
                        return true;
                    }
                    return reports.stream().filter(report -> report.getEventType() == EventType.NEW_PAYMENT).map(EventUpdateReport::getReportObjects).filter(Objects::nonNull).flatMap(Collection::stream).filter(NewPaymentReport.class::isInstance).map(NewPaymentReport.class::cast).filter(report -> report.getPaymentId() == payment.getId()).findFirst().filter(report -> !report.isAddedToCart()).isPresent();
                });
            }
            finally {
                DATABASE_QUERIES_LOCK.unlock();
            }
        }
        catch (ApiResponseFailureException ex) {
            this.warning("[PaymentsQuery] Response from API: %s", ex.getMessage());
            this.plugin.getDebugLogger().warn("[PaymentsQuery] Response from API: {0}", ex.getMessage());
        }
        catch (HttpRequestException | HttpResponseException ex) {
            this.error("[PaymentsQuery] %s", ex.getMessage());
            this.plugin.getDebugLogger().error("[PaymentsQuery] {0}", ex.getMessage());
            this.plugin.getDebugLogger().error(ex);
        }
        catch (IllegalStateException | RejectedExecutionException ex) {}
    }

    @NotNull
    private EventUpdates queryUpdates() {
        try {
            return this.easyPaymentsClient.getLongPollClient().getUpdatesListSync();
        }
        catch (ApiResponseFailureException ex) {
            this.warning("[PaymentsQuery] Response from API: %s", ex.getMessage());
            this.plugin.getDebugLogger().warn("[PaymentsQuery] Response from API: {0}", ex.getMessage());
        }
        catch (HttpRequestException | HttpResponseException ex) {
            Throwable lastCause = ThrowableCauseFinder.findLastCause(ex);
            if (lastCause instanceof SocketTimeoutException) {
                return null;
            }
            if (lastCause instanceof FileNotFoundException) {
                String endpointUrl = lastCause.getMessage();
                if (endpointUrl != null && !endpointUrl.isEmpty()) {
                    this.error("[PaymentsQuery] The EasyPayments endpoint '%s' isn't available now, I'll try to connect later...", endpointUrl);
                    this.plugin.getDebugLogger().error("[PaymentsQuery] The EasyPayments endpoint '{0}' isn't available now", endpointUrl);
                    this.plugin.getDebugLogger().error(lastCause);
                    throw new BadResponseException(404);
                }
            } else if (lastCause instanceof IOException) {
                try {
                    Matcher matcher = RESPONSE_CODE_EXCEPTION.matcher(lastCause.getMessage());
                    if (matcher.matches()) {
                        int code = Integer.parseInt(matcher.group("code"));
                        String url = matcher.group("url");
                        switch (code) {
                            case 403: {
                                this.error("Access denied! Please, make sure that you are using a latest version!");
                                this.plugin.getDebugLogger().error("[PaymentsQuery] Unsupported EasyPayments version (403)", new Object[0]);
                                break;
                            }
                            case 502: {
                                this.error("The EasyPayments LongPoll API endpoint isn't available now, will try to connect later...");
                                this.error("It may be caused by the work of the DDoS-attack protection of this service :(");
                                this.plugin.getDebugLogger().error("[PaymentsQuery] EasyDonate API is unavailable (502)", new Object[0]);
                                break;
                            }
                        }
                        if (code / 100 != 2 && code / 100 != 3) {
                            throw new BadResponseException(code);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.error("[PaymentsQuery] %s", ex.getMessage());
            this.plugin.getDebugLogger().error("[PaymentsQuery] {0}", ex.getMessage());
            this.plugin.getDebugLogger().error(ex);
        }
        return null;
    }

    private static final class BadResponseException
    extends RuntimeException {
        private final int httpCode;

        @Generated
        public int getHttpCode() {
            return this.httpCode;
        }

        @Generated
        public BadResponseException(int httpCode) {
            this.httpCode = httpCode;
        }
    }
}

