/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.task;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.easydonate4j.extension.client.EasyPaymentsClient;
import ru.easydonate.easypayments.service.KnownPlayersService;
import ru.easydonate.easypayments.task.AbstractPluginTask;

public final class KnownPlayersSyncTask
extends AbstractPluginTask {
    private static final long TASK_DELAY = 100L;
    private static final long TASK_PERIOD = 600L;
    private static final int UPLOAD_ATTEMPTS = 5;
    @NotNull
    private final KnownPlayersService knownPlayersService;
    @NotNull
    private final EasyPaymentsClient easyPaymentsClient;

    public KnownPlayersSyncTask(@NotNull EasyPaymentsPlugin plugin, @NotNull KnownPlayersService knownPlayersService, @NotNull EasyPaymentsClient easyPaymentsClient) {
        super(plugin, 100L);
        this.knownPlayersService = knownPlayersService;
        this.easyPaymentsClient = easyPaymentsClient;
    }

    @Override
    protected long getPeriod() {
        return 600L;
    }

    @Override
    public void run() {
        if (!this.isWorking()) {
            return;
        }
        HashMap<String, Boolean> players = new HashMap<String, Boolean>();
        this.knownPlayersService.drainJoinedPlayers(players::put);
        this.plugin.getServer().getOnlinePlayers().forEach(player -> players.put(player.getName(), true));
        if (players.isEmpty()) {
            return;
        }
        this.plugin.getDebugLogger().debug("[PlayersSync] Uploading known players ({0}):", players.size());
        this.plugin.getDebugLogger().debug(((Object)players).toString(), new Object[0]);
        try {
            for (int attempt = 0; attempt < 5; ++attempt) {
                try {
                    if (!this.easyPaymentsClient.uploadKnownPlayers(players)) {
                        this.plugin.getLogger().severe("An unknown error occured while trying to upload reports!");
                        this.plugin.getLogger().severe("Please, contact with the platform support:");
                        this.plugin.getLogger().severe("https://vk.me/easydonate");
                        return;
                    }
                    if (attempt > 0) {
                        this.plugin.getLogger().warning(String.format("Known players have been uploaded on attempt #%d! Ensure that your Internet connection is stable.", attempt + 1));
                    }
                    break;
                }
                catch (Exception ex) {
                    if (attempt == 4) {
                        throw ex;
                    }
                    this.plugin.getDebugLogger().warn("Couldn't upload known players! ({0} of {1})", attempt + 1, 5);
                    this.plugin.getDebugLogger().warn(ex);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        catch (Exception ex) {
            this.plugin.getDebugLogger().error("Couldn't upload known players!", new Object[0]);
            this.plugin.getDebugLogger().error(ex);
            this.error("Couldn't upload known players! Please, check your Internet connection!");
            this.error("This omission may issue some problems for your customers :(");
        }
    }
}

