/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.shopcart;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.PurchasedProduct;
import ru.easydonate.easypayments.core.logging.DebugLogger;

public final class ShopCartConfig {
    private final Configuration config;
    private final DebugLogger debugLogger;
    private boolean enabled;
    private boolean autoIssueEnabled;
    private List<Integer> blacklistedProductIds;
    private boolean blacklistReversed;

    public ShopCartConfig(@NotNull Configuration config, @NotNull DebugLogger debugLogger) {
        this.config = config;
        this.debugLogger = debugLogger;
    }

    public void reload() {
        this.enabled = this.config.getBoolean("shop-cart.enabled", true);
        this.autoIssueEnabled = this.config.getBoolean("shop-cart.auto-issue-when-online", true);
        this.blacklistedProductIds = this.config.getIntList("shop-cart.filtering.blacklist");
        this.blacklistReversed = this.config.getBoolean("shop-cart.filtering.use-as-whitelist", false);
        this.debugLogger.debug("[ShopCart] Enabled: {0}", this.enabled ? "YES" : "NO");
        this.debugLogger.debug("[ShopCart] Auto-issue: {0}", this.autoIssueEnabled ? "YES" : "NO");
        if (this.blacklistReversed) {
            this.debugLogger.debug("[ShopCart] Whitelisted products: {0}", this.blacklistedProductIds);
        } else {
            this.debugLogger.debug("[ShopCart] Blacklisted products: {0}", this.blacklistedProductIds);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldIssueWhenOnline() {
        return !this.enabled || this.autoIssueEnabled;
    }

    public boolean shouldAddToCart(@NotNull PurchasedProduct product) {
        return this.shouldAddToCart(product.getId()) && !product.isIssueNow();
    }

    public boolean shouldAddToCart(int productId) {
        if (!this.enabled) {
            return false;
        }
        if (this.blacklistReversed) {
            return this.blacklistedProductIds != null && this.blacklistedProductIds.contains(productId);
        }
        return this.blacklistedProductIds == null || !this.blacklistedProductIds.contains(productId);
    }
}

