/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.shopcart;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.libs.ormlite.dao.ForeignCollection;

public final class ShopCart {
    private final Customer customer;

    public ShopCart(@NotNull Customer customer) {
        this.customer = customer;
    }

    @NotNull
    public OfflinePlayer getCartHolder() {
        return this.customer.asBukkitPlayer();
    }

    @NotNull
    public Collection<Payment> getPayments() {
        ForeignCollection<Payment> payments = this.customer.getPayments();
        return payments != null && !payments.isEmpty() ? Collections.unmodifiableCollection(payments) : Collections.emptyList();
    }

    @NotNull
    public Collection<Payment> getContent() {
        return this.getPayments().stream().filter(Payment::isReported).filter(Payment::isUncollected).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        Collection<Payment> payments = this.getContent();
        if (payments == null || payments.isEmpty()) {
            return true;
        }
        for (Payment payment : payments) {
            if (!payment.hasPurchases() || !payment.getPurchases().stream().anyMatch(p -> !p.isCollected())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopCart shopCart = (ShopCart)o;
        return Objects.equals(this.customer, shopCart.customer);
    }

    public int hashCode() {
        return Objects.hash(this.customer);
    }

    @NotNull
    public String toString() {
        return "ShopCart{customer=" + this.customer + '}';
    }

    @Generated
    public Customer getCustomer() {
        return this.customer;
    }
}

