/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service.processor.object;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.easydonate4j.PluginEventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.NewPaymentReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.plugin.PluginEventReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.plugin.PurchaseNotificationsPluginEventReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.NewPaymentEvent;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.PurchasedProduct;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.plugin.PurchaseNotificationsPluginEvent;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.core.util.IndexedWrapper;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.service.processor.object.EventObjectProcessor;

public final class NewPaymentObjectProcessor
extends EventObjectProcessor<NewPaymentEvent, NewPaymentReport> {
    private final EasyPaymentsPlugin plugin;

    public NewPaymentObjectProcessor(@NotNull EasyPaymentsPlugin plugin) {
        this.plugin = plugin;
        super.registerPluginEventProcessor(PluginEventType.PURCHASE_NOTIFICATIONS, this::processPurchaseNotifications);
    }

    @Nullable
    private PluginEventReport processPurchaseNotifications(@NotNull PurchaseNotificationsPluginEvent pluginEvent) {
        List<String> commands = pluginEvent.getCommands();
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        List<CommandReport> reports = this.plugin.getExecutionService().processCommandsKeepSequence(commands);
        return new PurchaseNotificationsPluginEventReport(reports);
    }

    @Override
    @NotNull
    public NewPaymentReport processObject(@NotNull NewPaymentEvent eventObject) throws StructureValidationException {
        eventObject.validate();
        List<PurchasedProduct> products = eventObject.getProducts();
        products.forEach(PurchasedProduct::validate);
        int addToCartCount = (int)products.stream().filter(this.plugin.getShopCartConfig()::shouldAddToCart).count();
        int paymentId = eventObject.getPaymentId();
        String customerName = eventObject.getCustomer();
        UUID customerId = this.plugin.getPlatformProvider().resolvePlayerId(customerName);
        Player onlinePlayer = this.plugin.getServer().getPlayer(customerId);
        boolean isCustomerOnline = onlinePlayer != null && onlinePlayer.isOnline();
        boolean isAutoIssuanceActive = this.plugin.getShopCartConfig().shouldIssueWhenOnline() && isCustomerOnline;
        boolean addedToCart = !isAutoIssuanceActive && addToCartCount != 0;
        NewPaymentReport report = new NewPaymentReport(paymentId, addedToCart, customerName);
        Customer customer = this.plugin.getShopCartStorage().getShopCart(customerName, customerId).getCustomer();
        Payment payment = customer.createPayment(paymentId, this.plugin.getServerId());
        this.plugin.getPersistanceService().savePayment(payment).join();
        List purchases = products.stream().map(payment::createPurchase).collect(Collectors.toList());
        CompletableFuture[] futures = (CompletableFuture[])purchases.stream().map(this.plugin.getPersistanceService()::savePurchase).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        if (isAutoIssuanceActive || addToCartCount < products.size()) {
            AtomicInteger indexer = new AtomicInteger();
            List indexedWrappers = products.stream().filter(product -> isAutoIssuanceActive || !this.plugin.getShopCartConfig().shouldAddToCart((PurchasedProduct)product)).map(product -> new IndexedWrapper<PurchasedProduct>(indexer.getAndIncrement(), (PurchasedProduct)product)).collect(Collectors.toList());
            if (!indexedWrappers.isEmpty()) {
                Map<Integer, Integer> productIdsMapping = purchases.stream().collect(Collectors.toMap(Purchase::getProductId, Purchase::getId));
                List commandReports = indexedWrappers.parallelStream().map(product -> this.executeCommandAndPersistState(payment, (IndexedWrapper<PurchasedProduct>)product, productIdsMapping)).collect(Collectors.toList());
                commandReports.stream().sorted(Comparator.comparingInt(IndexedWrapper::getIndex)).map(IndexedWrapper::getObject).flatMap(Collection::stream).forEach(report::addCommandReport);
            }
            if (!isAutoIssuanceActive && addToCartCount != 0 && isCustomerOnline) {
                this.plugin.getMessages().getAndSend((CommandSender)onlinePlayer, "cart-notification", new Object[0]);
            }
        } else if (isCustomerOnline) {
            this.plugin.getMessages().getAndSend((CommandSender)onlinePlayer, "cart-notification", new Object[0]);
        }
        this.plugin.getPersistanceService().refreshCustomer(customer);
        return report;
    }

    @NotNull
    private IndexedWrapper<List<CommandReport>> executeCommandAndPersistState(@NotNull Payment payment, @NotNull IndexedWrapper<PurchasedProduct> product, @NotNull Map<Integer, Integer> productIdsMapping) {
        AtomicInteger indexer = new AtomicInteger();
        List<String> commands = product.getObject().getCommands();
        List<CommandReport> reports = this.plugin.getExecutionService().processCommandsKeepSequence(commands);
        Integer purchaseId = productIdsMapping.get(product.getObject().getId());
        if (purchaseId != null) {
            this.plugin.getPersistanceService().populatePurchaseWithReportData(payment, purchaseId, reports);
        } else {
            this.plugin.getDebugLogger().error("Couldn't find storage purchase ID for product #{0}", product.getObject().getId());
            this.plugin.getDebugLogger().error("Product IDs mapping: {0}", productIdsMapping);
        }
        return new IndexedWrapper<List<CommandReport>>(product.getIndex(), reports);
    }
}

