/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service.processor.object;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.easydonate4j.PluginEventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventReportObject;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.plugin.PluginEventReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.plugin.PluginEvent;
import ru.easydonate.easypayments.core.exception.PluginEventProcessingException;
import ru.easydonate.easypayments.core.exception.StructureValidationException;
import ru.easydonate.easypayments.service.processor.object.PluginEventProcessor;

public abstract class EventObjectProcessor<E extends EventObject, R extends EventReportObject> {
    protected final Map<PluginEventType, PluginEventProcessor<?>> pluginEventProcessors = new LinkedHashMap();

    protected EventObjectProcessor() {
    }

    @NotNull
    public abstract R processObject(@NotNull E var1) throws StructureValidationException;

    protected <P extends PluginEvent> void registerPluginEventProcessor(@NotNull PluginEventType pluginType, @NotNull PluginEventProcessor<P> pluginEventProcessor) {
        this.pluginEventProcessors.put(pluginType, pluginEventProcessor);
    }

    @NotNull
    public R processPluginEvents(@NotNull E eventObject, @NotNull R eventReportObject) {
        if (eventObject == null || eventReportObject == null) {
            return eventReportObject;
        }
        if (((EventObject)eventObject).hasPluginEvents()) {
            ((EventObject)eventObject).getPluginEvents().stream().map(this::processPluginEvent).filter(Objects::nonNull).forEach(arg_0 -> eventReportObject.addPluginEventReport(arg_0));
        }
        return eventReportObject;
    }

    @Nullable
    private <P extends PluginEvent> PluginEventReport processPluginEvent(@NotNull PluginEvent pluginEvent) {
        PluginEventType pluginType = pluginEvent.getPluginType();
        if (pluginType.isUnknown()) {
            return null;
        }
        PluginEventProcessor<?> processor = this.pluginEventProcessors.get((Object)pluginType);
        if (processor == null) {
            return null;
        }
        try {
            return processor.process(pluginEvent);
        }
        catch (Exception ex) {
            throw new PluginEventProcessingException(pluginEvent, (Throwable)ex);
        }
    }
}

