/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service.execution;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.interceptor.FeedbackInterceptor;
import ru.easydonate.easypayments.core.util.IndexedWrapper;

public final class ExecutionWrapper
extends IndexedWrapper<FeedbackInterceptor> {
    private final String command;

    public ExecutionWrapper(int index, @NotNull String command) {
        super(index);
        this.command = command;
    }

    public ExecutionWrapper(int index, @Nullable FeedbackInterceptor interceptor, @NotNull String command) {
        super(index, interceptor);
        this.command = command;
    }

    @Nullable
    public CommandReport createReport() {
        FeedbackInterceptor interceptor = (FeedbackInterceptor)this.getObject();
        if (interceptor == null) {
            return null;
        }
        return CommandReport.create(this.command, interceptor.getFeedbackMessages());
    }

    @NotNull
    public ExecutionWrapper setObject(@Nullable FeedbackInterceptor object) {
        super.setObject(object);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecutionWrapper that = (ExecutionWrapper)o;
        return Objects.equals(this.command, that.command);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.command);
    }

    @Override
    @NotNull
    public String toString() {
        return "ExecutionWrapper{command='" + this.command + '\'' + ", index=" + this.index + ", ru.easydonate.easypayments.internal.nms.interceptor=" + this.object + '}';
    }
}

