/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service.execution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.interceptor.FeedbackInterceptor;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.util.PluginThreadFactory;
import ru.easydonate.easypayments.core.util.ThreadLocker;
import ru.easydonate.easypayments.exception.CommandExecutionException;
import ru.easydonate.easypayments.service.execution.ExecutionWrapper;

public final class ExecutionService {
    private final EasyPayments plugin;
    private final Configuration config;
    private final InterceptorFactory interceptorFactory;
    private final ExecutorService commandsExecutorService;

    public ExecutionService(@NotNull EasyPayments plugin, @NotNull Configuration config, @NotNull InterceptorFactory interceptorFactory) {
        this.plugin = plugin;
        this.config = config;
        this.interceptorFactory = interceptorFactory;
        this.commandsExecutorService = this.createAsyncExecutorService();
    }

    public void shutdown() {
        if (this.commandsExecutorService != null) {
            this.commandsExecutorService.shutdown();
        }
    }

    public int getFeedbackAwaitTimeMillis() {
        return this.config.getIntWithBounds("feedback-await-time", 1000, 5000, 3000);
    }

    @NotNull
    public List<CommandReport> processCommandsKeepSequence(@NotNull List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return Collections.emptyList();
        }
        AtomicInteger indexer = new AtomicInteger();
        CompletableFuture[] futures = (CompletableFuture[])commands.stream().map(command -> this.processCommandIndexed((String)command, indexer.getAndIncrement())).toArray(CompletableFuture[]::new);
        long start = System.currentTimeMillis();
        CompletableFuture.allOf(futures).join();
        long time = System.currentTimeMillis() - start;
        int awaitTimeMillis = this.getFeedbackAwaitTimeMillis();
        if ((long)awaitTimeMillis > time) {
            ThreadLocker.lockUninterruptive((long)awaitTimeMillis - time);
        }
        return ((Stream)Arrays.stream(futures).map(CompletableFuture::join).filter(Objects::nonNull).sequential()).map(object -> (ExecutionWrapper)object).filter(wrapper -> wrapper.getObject() != null).sorted().map(ExecutionWrapper::createReport).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public CompletableFuture<ExecutionWrapper> processCommandIndexed(@NotNull String command, int index) {
        ExecutionWrapper wrapper = new ExecutionWrapper(index, command);
        return this.processCommand(command).thenApply(wrapper::setObject);
    }

    @NotNull
    public CompletableFuture<FeedbackInterceptor> processCommand(@NotNull String command) {
        return ((CompletableFuture)this.interceptorFactory.createFeedbackInterceptorAsync().thenCompose(interceptor -> this.executeCommand((FeedbackInterceptor)interceptor, command))).exceptionally(this::handleExceptionalExecution);
    }

    @NotNull
    private CompletableFuture<FeedbackInterceptor> executeCommand(@NotNull FeedbackInterceptor interceptor, @NotNull String command) throws CommandExecutionException {
        try {
            Bukkit.dispatchCommand((CommandSender)interceptor.getCommandSender(), (String)command);
            return CompletableFuture.supplyAsync(() -> interceptor, this.commandsExecutorService);
        }
        catch (Throwable throwable) {
            throw new CommandExecutionException(command, interceptor, throwable);
        }
    }

    @NotNull
    private FeedbackInterceptor handleExceptionalExecution(@NotNull Throwable cause) {
        if (cause instanceof CompletionException) {
            if ((cause = cause.getCause()) instanceof CommandExecutionException) {
                CommandExecutionException exception = (CommandExecutionException)cause;
                cause = exception.getCause();
                String command = exception.getCommand();
                FeedbackInterceptor executor = exception.getExecutor();
                String response = exception.getMessage();
                boolean stackTracePrintRequired = false;
                this.plugin.getLogger().severe(response);
                executor.getFeedbackMessages().add(response);
                if (cause instanceof CommandException) {
                    CommandException bukkitException = (CommandException)cause;
                    String bukkitMessage = bukkitException.getMessage();
                    cause = bukkitException.getCause();
                    stackTracePrintRequired = true;
                    this.plugin.getDebugLogger().error(bukkitMessage, new Object[0]);
                    executor.getFeedbackMessages().add(bukkitMessage);
                }
                if (stackTracePrintRequired && cause != null) {
                    this.plugin.getDebugLogger().error(cause);
                }
                return executor;
            }
        } else if (cause instanceof CancellationException || cause instanceof RejectedExecutionException) {
            return null;
        }
        this.plugin.getLogger().severe("An error occurred while processing a purchase issue command!");
        this.plugin.getLogger().severe("Tip: check EasyPayments logs for additional information");
        if (cause != null) {
            this.plugin.getDebugLogger().error("An unexpected exception has been thrown", new Object[0]);
            this.plugin.getDebugLogger().error(cause);
        } else {
            this.plugin.getDebugLogger().error("An unexpected exception has been thrown (no cause provided)", new Object[0]);
        }
        return null;
    }

    @NotNull
    private ExecutorService createAsyncExecutorService() {
        int threadPoolSize = this.config.getInt("execution-thread-pool-size", -1);
        PluginThreadFactory threadFactory = new PluginThreadFactory("Command Execution Worker");
        return threadPoolSize > 0 ? Executors.newFixedThreadPool(threadPoolSize, threadFactory) : Executors.newCachedThreadPool(threadFactory);
    }

    @Generated
    public EasyPayments getPlugin() {
        return this.plugin;
    }

    @Generated
    public Configuration getConfig() {
        return this.config;
    }

    @Generated
    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }

    @Generated
    public ExecutorService getCommandsExecutorService() {
        return this.commandsExecutorService;
    }
}

