/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.EasyPaymentsPlugin;
import ru.easydonate.easypayments.core.easydonate4j.EventType;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventReportObject;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReport;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.EventUpdateReports;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventObject;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdate;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.EventUpdates;
import ru.easydonate.easypayments.core.util.PluginThreadFactory;
import ru.easydonate.easypayments.service.execution.ExecutionService;
import ru.easydonate.easypayments.service.processor.object.EventObjectProcessor;
import ru.easydonate.easypayments.service.processor.object.NewPaymentObjectProcessor;
import ru.easydonate.easypayments.service.processor.object.NewRewardObjectProcessor;
import ru.easydonate.easypayments.service.processor.object.NewWithdrawObjectProcessor;
import ru.easydonate.easypayments.service.processor.object.RepeatPaymentObjectProcessor;
import ru.easydonate.easypayments.service.processor.update.EventUpdateProcessor;
import ru.easydonate.easypayments.service.processor.update.SimplePaymentEventProcessor;

public final class LongPollEventDispatcher {
    private final EasyPaymentsPlugin plugin;
    private final ExecutionService executionService;
    private final ExecutorService asyncExecutorPool;
    private final Map<EventType, EventObjectProcessor<?, ?>> eventObjectProcessors;
    private final Map<EventType, EventUpdateProcessor<?, ?>> eventUpdateProcessors;

    public LongPollEventDispatcher(@NotNull EasyPaymentsPlugin plugin, @NotNull ExecutionService executionService) {
        this.plugin = plugin;
        this.executionService = executionService;
        this.asyncExecutorPool = Executors.newCachedThreadPool(new PluginThreadFactory("Async Processing Worker"));
        this.eventObjectProcessors = new HashMap();
        this.eventUpdateProcessors = new HashMap();
        this.registerDefaults();
    }

    public void shutdown() {
        if (this.asyncExecutorPool != null) {
            this.asyncExecutorPool.shutdown();
        }
    }

    @NotNull
    public CompletableFuture<EventUpdateReports> processEventUpdates(@NotNull EventUpdates eventUpdates) {
        return CompletableFuture.supplyAsync(() -> {
            EventUpdateReports reports = eventUpdates.createReports();
            ((Stream)eventUpdates.parallelStream().map(this::processEventUpdate).map(CompletableFuture::join).sequential()).forEach(reports::add);
            return reports;
        }, this.asyncExecutorPool);
    }

    @NotNull
    public <E extends EventObject, R extends EventReportObject> CompletableFuture<EventUpdateReport<R>> processEventUpdate(@NotNull EventUpdate<E> eventUpdate) {
        EventType eventType = eventUpdate.getEventType();
        EventUpdateProcessor<?, ?> processor = this.eventUpdateProcessors.get((Object)eventType);
        if (processor == null) {
            throw new IllegalArgumentException(String.format("There are no event update processor present for event type '%s'!", new Object[]{eventType}));
        }
        return CompletableFuture.supplyAsync(() -> processor.processUpdate(eventUpdate), this.asyncExecutorPool);
    }

    @NotNull
    public <E extends EventObject, R extends EventReportObject> CompletableFuture<R> processEventObject(@NotNull EventType eventType, @NotNull E eventObject) {
        EventObjectProcessor<?, ?> processor = this.eventObjectProcessors.get((Object)eventType);
        if (processor == null) {
            throw new IllegalArgumentException(String.format("There are no event object processor present for event type '%s'!", new Object[]{eventType}));
        }
        return CompletableFuture.supplyAsync(() -> processor.processObject(eventObject), this.asyncExecutorPool).thenApply(report -> processor.processPluginEvents(eventObject, report));
    }

    private void registerDefaults() {
        this.eventObjectProcessors.put(EventType.NEW_PAYMENT, new NewPaymentObjectProcessor(this.plugin));
        this.eventObjectProcessors.put(EventType.REPEAT_PAYMENT, new RepeatPaymentObjectProcessor(this.executionService));
        this.eventObjectProcessors.put(EventType.NEW_WITHDRAW, new NewWithdrawObjectProcessor(this.executionService));
        this.eventObjectProcessors.put(EventType.NEW_REWARD, new NewRewardObjectProcessor(this.executionService));
        this.eventUpdateProcessors.put(EventType.NEW_PAYMENT, new SimplePaymentEventProcessor(this));
        this.eventUpdateProcessors.put(EventType.REPEAT_PAYMENT, new SimplePaymentEventProcessor(this));
        this.eventUpdateProcessors.put(EventType.NEW_WITHDRAW, new SimplePaymentEventProcessor(this));
        this.eventUpdateProcessors.put(EventType.NEW_REWARD, new SimplePaymentEventProcessor(this));
    }
}

