/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.service;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class KnownPlayersService {
    @NotNull
    private final Map<String, WeakReference<Player>> joinedSinceLastDrain = new HashMap<String, WeakReference<Player>>();
    @NotNull
    private final Lock joinedSinceLastDrainLock = new ReentrantLock();

    public void drainJoinedPlayers(@NotNull BiConsumer<String, Boolean> consumer) {
        HashMap<String, WeakReference<Player>> threadSafeCopy;
        try {
            this.joinedSinceLastDrainLock.lock();
            if (this.joinedSinceLastDrain.isEmpty()) {
                return;
            }
            threadSafeCopy = new HashMap<String, WeakReference<Player>>(this.joinedSinceLastDrain);
            this.joinedSinceLastDrain.clear();
        }
        finally {
            this.joinedSinceLastDrainLock.unlock();
        }
        threadSafeCopy.forEach((playerName, playerRef) -> {
            Player player;
            boolean isOnline = false;
            if (playerRef != null && (player = (Player)playerRef.get()) != null) {
                isOnline = player.isOnline();
            }
            consumer.accept((String)playerName, isOnline);
        });
    }

    public void rememberJoinedPlayer(@NotNull Player player) {
        try {
            this.joinedSinceLastDrainLock.lock();
            this.joinedSinceLastDrain.put(player.getName(), new WeakReference<Player>(player));
        }
        finally {
            this.joinedSinceLastDrainLock.unlock();
        }
    }
}

