/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.platform.spigot.v1_8_R2;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.v1_8_R2.DedicatedServer;
import org.bukkit.craftbukkit.v1_8_R2.CraftServer;
import org.bukkit.craftbukkit.v1_8_R2.scheduler.CraftTask;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.platform.provider.kind.SpigotPlatformProviderBase;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;
import ru.easydonate.easypayments.core.util.Reflection;
import ru.easydonate.easypayments.platform.spigot.v1_8_R2.interceptor.PlatformInterceptorFactory;

public final class PlatformProvider
extends SpigotPlatformProviderBase {
    @Nullable
    private static final Method CraftTask$getPeriod = Reflection.getDeclaredMethod(CraftTask.class, "getPeriod", new Class[0]);

    public PlatformProvider(@NotNull EasyPayments plugin, @NotNull PlatformScheduler scheduler, @NotNull String executorName, int permissionLevel) {
        super(plugin, scheduler, executorName, permissionLevel);
    }

    @Override
    @NotNull
    protected InterceptorFactory createInterceptorFactory() {
        return new PlatformInterceptorFactory(this, this.executorName, this.permissionLevel);
    }

    @Override
    @NotNull
    protected UUID resolveOfflinePlayerId(@NotNull String name) {
        GameProfile profile;
        DedicatedServer server = ((CraftServer)this.plugin.getServer()).getHandle().getServer();
        if ((server.getOnlineMode() || SpigotConfig.bungee) && (profile = server.getUserCache().getProfile(name)) != null) {
            return profile.getId();
        }
        return this.generateOfflinePlayerId(name);
    }

    @Override
    public boolean isTaskCancelled(@NotNull BukkitTask bukkitTask) {
        try {
            return super.isTaskCancelled(bukkitTask);
        }
        catch (Throwable ignored) {
            if (bukkitTask instanceof CraftTask) {
                Optional result = Reflection.invokeMethod(CraftTask$getPeriod, bukkitTask, new Object[0]);
                return !result.isPresent() || (Long)result.get() == -2L;
            }
            throw new IllegalArgumentException(String.format("this bukkit task isn't a CraftTask instance! (%s)", bukkitTask.getClass()));
        }
    }
}

