/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.platform.paper.internals.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.command.ServerCommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.interceptor.FeedbackInterceptor;

final class InterceptedCommandSource
extends ServerCommandSender
implements CommandSource,
FeedbackInterceptor {
    private final String username;
    private final List<String> feedbackMessages;

    public InterceptedCommandSource(String username) {
        this.username = username;
        this.feedbackMessages = new ArrayList<String>();
    }

    public void sendSystemMessage(Component component) {
        this.feedbackMessages.add(component.getString());
    }

    public boolean acceptsSuccess() {
        return true;
    }

    public boolean acceptsFailure() {
        return true;
    }

    public boolean shouldInformAdmins() {
        return false;
    }

    public CommandSender getBukkitSender(CommandSourceStack commandSourceStack) {
        return this;
    }

    public void sendMessage(String message) {
        this.feedbackMessages.add(message);
    }

    public void sendMessage(String[] messages) {
        this.feedbackMessages.addAll(Arrays.asList(messages));
    }

    public String getName() {
        return this.username;
    }

    public @NotNull net.kyori.adventure.text.Component name() {
        return net.kyori.adventure.text.Component.text((String)this.getName());
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
    }

    public boolean hasPermission(String name) {
        return true;
    }

    public boolean hasPermission(Permission perm) {
        return true;
    }

    public boolean isPermissionSet(String name) {
        return true;
    }

    public boolean isPermissionSet(Permission perm) {
        return true;
    }

    @Override
    @Generated
    public List<String> getFeedbackMessages() {
        return this.feedbackMessages;
    }
}

