/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.stmt.mapped;

import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.dao.Dao;
import ru.easydonate.easypayments.libs.ormlite.dao.ObjectCache;
import ru.easydonate.easypayments.libs.ormlite.db.DatabaseType;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.stmt.mapped.BaseMappedQuery;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseConnection;
import ru.easydonate.easypayments.libs.ormlite.table.TableInfo;

public class MappedQueryForFieldEq<T, ID>
extends BaseMappedQuery<T, ID> {
    private final String label;

    protected MappedQueryForFieldEq(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultsFieldTypes, String label) {
        super(dao, tableInfo, statement, argFieldTypes, resultsFieldTypes);
        this.label = label;
    }

    public T execute(DatabaseConnection databaseConnection, ID id, ObjectCache objectCache) throws SQLException {
        Object result;
        if (objectCache != null && (result = objectCache.get(this.clazz, id)) != null) {
            return result;
        }
        Object[] args = new Object[]{this.convertIdToFieldObject(id)};
        Object result2 = databaseConnection.queryForOne(this.statement, args, this.argFieldTypes, this, objectCache);
        if (result2 == null) {
            logger.debug("{} using '{}' and {} args, got no results", (Object)this.label, (Object)this.statement, (Object)args.length);
        } else {
            if (result2 == DatabaseConnection.MORE_THAN_ONE) {
                logger.error("{} using '{}' and {} args, got >1 results", (Object)this.label, (Object)this.statement, (Object)args.length);
                this.logArgs(args);
                throw new SQLException(this.label + " got more than 1 result: " + this.statement);
            }
            logger.debug("{} using '{}' and {} args, got 1 result", (Object)this.label, (Object)this.statement, (Object)args.length);
        }
        this.logArgs(args);
        Object castResult = result2;
        return (T)castResult;
    }

    public static <T, ID> MappedQueryForFieldEq<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, FieldType idFieldType) throws SQLException {
        if (idFieldType == null && (idFieldType = tableInfo.getIdField()) == null) {
            throw new SQLException("Cannot query-for-id with " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        String statement = MappedQueryForFieldEq.buildStatement(databaseType, tableInfo, idFieldType);
        return new MappedQueryForFieldEq<T, ID>(dao, tableInfo, statement, new FieldType[]{idFieldType}, tableInfo.getFieldTypes(), "query-for-id");
    }

    protected static <T, ID> String buildStatement(DatabaseType databaseType, TableInfo<T, ID> tableInfo, FieldType idFieldType) {
        StringBuilder sb = new StringBuilder(64);
        MappedQueryForFieldEq.appendTableName(databaseType, sb, "SELECT * FROM ", tableInfo);
        MappedQueryForFieldEq.appendWhereFieldEq(databaseType, idFieldType, sb, null);
        return sb.toString();
    }

    private void logArgs(Object[] args) {
        if (args.length > 0) {
            logger.trace("{} arguments: {}", (Object)this.label, (Object)args);
        }
    }
}

