/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.logger;

import ru.easydonate.easypayments.libs.ormlite.logger.Level;
import ru.easydonate.easypayments.libs.ormlite.logger.LogBackend;
import ru.easydonate.easypayments.libs.ormlite.logger.LogBackendFactory;
import ru.easydonate.easypayments.libs.ormlite.logger.LogBackendUtil;

public class ConsoleLogBackend
implements LogBackend {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private String className;

    public ConsoleLogBackend(String className) {
        this.className = className;
    }

    @Override
    public boolean isLevelEnabled(Level level) {
        return true;
    }

    @Override
    public void log(Level level, String msg) {
        String output = this.className + ' ' + (Object)((Object)level) + ' ' + msg + LINE_SEPARATOR;
        if (Level.WARNING.isEnabled(level)) {
            System.err.print(output);
        } else {
            System.out.print(output);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable throwable) {
        this.log(level, msg);
        if (throwable != null) {
            this.log(level, LogBackendUtil.throwableToString(throwable));
        }
    }

    public static class ConsoleLogBackendFactory
    implements LogBackendFactory {
        @Override
        public LogBackend createLogBackend(String classLabel) {
            return new ConsoleLogBackend(classLabel);
        }
    }
}

