/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.jdbc.db;

import java.util.List;
import ru.easydonate.easypayments.libs.ormlite.db.BaseDatabaseType;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;

public class MysqlDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "mysql";
    private static final String DRIVER_CLASS_NAME_OLD = "com.mysql.jdbc.Driver";
    private static final String DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String DATABASE_NAME = "MySQL";
    public static final String DEFAULT_CREATE_TABLE_SUFFIX = "ENGINE=InnoDB";
    private String createTableSuffix = "ENGINE=InnoDB";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME, DRIVER_CLASS_NAME_OLD};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    public void setCreateTableSuffix(String createTableSuffix) {
        this.createTableSuffix = createTableSuffix;
    }

    @Override
    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DATETIME");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("TINYINT(1)");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("AUTO_INCREMENT ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendCreateTableSuffix(StringBuilder sb) {
        sb.append(this.createTableSuffix);
        sb.append(' ');
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public boolean isCreateIndexIfNotExistsSupported() {
        return false;
    }

    @Override
    public boolean isLimitUpdateAtEndSupported() {
        return true;
    }

    @Override
    public boolean isLimitDeleteAtEndSupported() {
        return super.isLimitDeleteAtEndSupported();
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        super.appendByteArrayType(sb, fieldType, fieldWidth);
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        super.appendLongStringType(sb, fieldType, fieldWidth);
    }
}

