/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BaseEnumType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class EnumStringType
extends BaseEnumType {
    public static int DEFAULT_WIDTH = 100;
    private static final EnumStringType singleTon = new EnumStringType();

    public static EnumStringType getSingleton() {
        return singleTon;
    }

    private EnumStringType() {
        super(SqlType.STRING, new Class[]{Enum.class});
    }

    protected EnumStringType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        if (fieldType == null) {
            return sqlArg;
        }
        String value = (String)sqlArg;
        Map enumStringMap = (Map)fieldType.getDataTypeConfigObj();
        if (enumStringMap == null) {
            return EnumStringType.enumVal(fieldType, value, null, fieldType.getUnknownEnumVal());
        }
        return EnumStringType.enumVal(fieldType, value, (Enum)enumStringMap.get(value), fieldType.getUnknownEnumVal());
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return defaultStr;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Enum enumVal = (Enum)obj;
        return this.getEnumName(enumVal);
    }

    @Override
    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        HashMap<String, Enum> enumStringMap = new HashMap<String, Enum>();
        Enum[] constants = (Enum[])fieldType.getType().getEnumConstants();
        if (constants == null) {
            throw new SQLException("Could not get enum-constants for field " + fieldType + ", not an enum or maybe generic?");
        }
        for (Enum enumVal : constants) {
            enumStringMap.put(this.getEnumName(enumVal), enumVal);
        }
        return enumStringMap;
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    protected String getEnumName(Enum<?> enumVal) {
        return enumVal.name();
    }
}

