/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.field.types;

import java.math.BigInteger;
import java.sql.SQLException;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.BaseDataType;
import ru.easydonate.easypayments.libs.ormlite.support.DatabaseResults;

public class BigIntegerType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 255;
    private static final BigIntegerType singleTon = new BigIntegerType();

    public static BigIntegerType getSingleton() {
        return singleTon;
    }

    protected BigIntegerType() {
        super(SqlType.STRING, new Class[]{BigInteger.class});
    }

    protected BigIntegerType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return new BigInteger(defaultStr).toString();
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Problems with field " + fieldType + " parsing default BigInteger string '" + defaultStr + "'", e);
        }
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getString(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        try {
            return new BigInteger((String)sqlArg);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Problems with column " + columnPos + " parsing BigInteger string '" + sqlArg + "'", e);
        }
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        BigInteger bigInteger = (BigInteger)obj;
        return bigInteger.toString();
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        if (currentValue == null) {
            return BigInteger.ONE;
        }
        return ((BigInteger)currentValue).add(BigInteger.ONE);
    }

    @Override
    public Object convertIdNumber(Number number) {
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public boolean isValidGeneratedType() {
        return true;
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }
}

