/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.db;

import java.util.List;
import ru.easydonate.easypayments.libs.ormlite.db.BaseDatabaseType;
import ru.easydonate.easypayments.libs.ormlite.field.DataPersister;
import ru.easydonate.easypayments.libs.ormlite.field.FieldConverter;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.converter.BooleanNumberFieldConverter;
import ru.easydonate.easypayments.libs.ormlite.field.types.BigDecimalStringType;

public abstract class BaseSqliteDatabaseType
extends BaseDatabaseType {
    @Override
    protected void appendLongType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (fieldType.getSqlType() == SqlType.LONG && fieldType.isGeneratedId()) {
            sb.append("INTEGER");
        } else {
            sb.append("BIGINT");
        }
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        if (fieldType.getSqlType() != SqlType.INTEGER && fieldType.getSqlType() != SqlType.LONG) {
            throw new IllegalArgumentException("Sqlite requires that auto-increment generated-id be integer or long type");
        }
        sb.append("PRIMARY KEY AUTOINCREMENT ");
    }

    @Override
    protected boolean generatedIdSqlAtEnd() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return true;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister, FieldType fieldType) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return BooleanNumberFieldConverter.getSingleton();
            }
            case BIG_DECIMAL: {
                return BigDecimalStringType.getSingleton();
            }
        }
        return super.getFieldConverter(dataPersister, fieldType);
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }
}

