/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.ormlite.dao;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ru.easydonate.easypayments.libs.ormlite.dao.BaseDaoImpl;
import ru.easydonate.easypayments.libs.ormlite.dao.Dao;
import ru.easydonate.easypayments.libs.ormlite.db.DatabaseType;
import ru.easydonate.easypayments.libs.ormlite.logger.Logger;
import ru.easydonate.easypayments.libs.ormlite.logger.LoggerFactory;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;
import ru.easydonate.easypayments.libs.ormlite.table.DatabaseTable;
import ru.easydonate.easypayments.libs.ormlite.table.DatabaseTableConfig;

public class DaoManager {
    private static Map<Class<?>, DatabaseTableConfig<?>> configMap = null;
    private static Map<ClassConnectionSource, Dao<?, ?>> classMap = null;
    private static Map<TableConfigConnectionSource, Dao<?, ?>> tableConfigMap = null;
    private static Logger logger = LoggerFactory.getLogger(DaoManager.class);

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClassConnectionSource key = new ClassConnectionSource(connectionSource, clazz);
        Dao dao = DaoManager.lookupDao(key);
        if (dao != null) {
            Dao castDao = dao;
            return (D)castDao;
        }
        dao = (Dao)DaoManager.createDaoFromConfig(connectionSource, clazz);
        if (dao != null) {
            Dao castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            DatabaseType databaseType = connectionSource.getDatabaseType();
            DatabaseTableConfig<T> config = databaseType.extractDatabaseTableConfig(connectionSource, clazz);
            Dao daoTmp = config == null ? BaseDaoImpl.createDao(connectionSource, clazz) : BaseDaoImpl.createDao(connectionSource, config);
            dao = daoTmp;
            logger.debug("created dao for class {} with reflection", clazz);
        } else {
            Object[] arguments;
            Class<?> daoClass = databaseTable.daoClass();
            Constructor<?> daoConstructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource, clazz});
            if (daoConstructor == null && (daoConstructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource})) == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource and optional Class parameters " + daoClass + ".  Missing static on class?");
            }
            try {
                dao = (Dao)daoConstructor.newInstance(arguments);
                logger.debug("created dao for class {} from constructor", clazz);
            }
            catch (Exception e) {
                throw new SQLException("Could not call the constructor in class " + daoClass, e);
            }
        }
        DaoManager.registerDao(connectionSource, dao);
        Dao castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, Class<T> clazz) {
        Dao<?, ?> dao;
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClassConnectionSource key = new ClassConnectionSource(connectionSource, clazz);
        Dao<?, ?> castDao = dao = DaoManager.lookupDao(key);
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        return DaoManager.doCreateDao(connectionSource, tableConfig);
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        TableConfigConnectionSource key = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao == null) {
            return null;
        }
        Dao<?, ?> castDao = dao;
        return (D)castDao;
    }

    public static synchronized void registerDao(ConnectionSource connectionSource, Dao<?, ?> dao) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        DaoManager.addDaoToClassMap(new ClassConnectionSource(connectionSource, dao.getDataClass()), dao);
    }

    public static synchronized void unregisterDao(ConnectionSource connectionSource, Dao<?, ?> dao) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        DaoManager.removeDaoToClassMap(new ClassConnectionSource(connectionSource, dao.getDataClass()));
    }

    public static synchronized void unregisterDaos(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        DaoManager.removeDaosFromConnectionClassMap(connectionSource);
    }

    public static synchronized void registerDaoWithTableConfig(ConnectionSource connectionSource, Dao<?, ?> dao) {
        DatabaseTableConfig tableConfig;
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        if (dao instanceof BaseDaoImpl && (tableConfig = ((BaseDaoImpl)dao).getTableConfig()) != null) {
            DaoManager.addDaoToTableMap(new TableConfigConnectionSource(connectionSource, tableConfig), dao);
            return;
        }
        DaoManager.addDaoToClassMap(new ClassConnectionSource(connectionSource, dao.getDataClass()), dao);
    }

    public static synchronized void clearCache() {
        if (configMap != null) {
            configMap.clear();
            configMap = null;
        }
        DaoManager.clearDaoCache();
    }

    public static synchronized void clearDaoCache() {
        if (classMap != null) {
            classMap.clear();
            classMap = null;
        }
        if (tableConfigMap != null) {
            tableConfigMap.clear();
            tableConfigMap = null;
        }
    }

    public static synchronized void addCachedDatabaseConfigs(Collection<DatabaseTableConfig<?>> configs) {
        HashMap<Object, Object> newMap = configMap == null ? new HashMap() : new HashMap(configMap);
        for (DatabaseTableConfig<?> config : configs) {
            newMap.put(config.getDataClass(), config);
            logger.info("Loaded configuration for {}", config.getDataClass());
        }
        configMap = newMap;
    }

    private static void addDaoToClassMap(ClassConnectionSource key, Dao<?, ?> dao) {
        if (classMap == null) {
            classMap = new HashMap();
        }
        classMap.put(key, dao);
    }

    private static void removeDaoToClassMap(ClassConnectionSource key) {
        if (classMap != null) {
            classMap.remove(key);
        }
    }

    private static void removeDaosFromConnectionClassMap(ConnectionSource connectionSource) {
        if (classMap != null) {
            Iterator<ClassConnectionSource> classIterator = classMap.keySet().iterator();
            while (classIterator.hasNext()) {
                if (classIterator.next().connectionSource != connectionSource) continue;
                classIterator.remove();
            }
        }
    }

    private static void addDaoToTableMap(TableConfigConnectionSource key, Dao<?, ?> dao) {
        if (tableConfigMap == null) {
            tableConfigMap = new HashMap();
        }
        tableConfigMap.put(key, dao);
    }

    private static <T> Dao<?, ?> lookupDao(ClassConnectionSource key) {
        Dao<?, ?> dao;
        if (classMap == null) {
            classMap = new HashMap();
        }
        if ((dao = classMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    private static <T> Dao<?, ?> lookupDao(TableConfigConnectionSource key) {
        Dao<?, ?> dao;
        if (tableConfigMap == null) {
            tableConfigMap = new HashMap();
        }
        if ((dao = tableConfigMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    private static Constructor<?> findConstructor(Class<?> daoClass, Object[] params) {
        for (Constructor<?> constructor : daoClass.getConstructors()) {
            Class<?>[] paramsTypes = constructor.getParameterTypes();
            if (paramsTypes.length != params.length) continue;
            boolean match = true;
            for (int i = 0; i < paramsTypes.length; ++i) {
                if (paramsTypes[i].isAssignableFrom(params[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return constructor;
        }
        return null;
    }

    private static <D, T> D createDaoFromConfig(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        D configedDao;
        if (configMap == null) {
            return null;
        }
        DatabaseTableConfig<?> config = configMap.get(clazz);
        if (config == null) {
            return null;
        }
        D castDao = configedDao = DaoManager.doCreateDao(connectionSource, config);
        return castDao;
    }

    private static <D extends Dao<T, ?>, T> D doCreateDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        TableConfigConnectionSource tableKey = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(tableKey);
        if (dao != null) {
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        Class<T> dataClass = tableConfig.getDataClass();
        ClassConnectionSource classKey = new ClassConnectionSource(connectionSource, dataClass);
        dao = DaoManager.lookupDao(classKey);
        if (dao != null) {
            DaoManager.addDaoToTableMap(tableKey, dao);
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = tableConfig.getDataClass().getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            Dao daoTmp = BaseDaoImpl.createDao(connectionSource, tableConfig);
            dao = daoTmp;
        } else {
            Object[] arguments;
            Class<?> daoClass = databaseTable.daoClass();
            Constructor<?> constructor = DaoManager.findConstructor(daoClass, arguments = new Object[]{connectionSource, tableConfig});
            if (constructor == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource, DatabaseTableConfig parameters in class " + daoClass);
            }
            try {
                dao = (Dao<?, ?>)constructor.newInstance(arguments);
            }
            catch (Exception e) {
                throw new SQLException("Could not call the constructor in class " + daoClass, e);
            }
        }
        DaoManager.addDaoToTableMap(tableKey, dao);
        logger.debug("created dao for class {} from table config", dataClass);
        if (DaoManager.lookupDao(classKey) == null) {
            DaoManager.addDaoToClassMap(classKey, dao);
        }
        Dao<Object, Object> castDao = dao;
        return (D)castDao;
    }

    private static class TableConfigConnectionSource {
        ConnectionSource connectionSource;
        DatabaseTableConfig<?> tableConfig;

        public TableConfigConnectionSource(ConnectionSource connectionSource, DatabaseTableConfig<?> tableConfig) {
            this.connectionSource = connectionSource;
            this.tableConfig = tableConfig;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.tableConfig.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TableConfigConnectionSource other = (TableConfigConnectionSource)obj;
            if (!this.tableConfig.equals(other.tableConfig)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }

    private static class ClassConnectionSource {
        ConnectionSource connectionSource;
        Class<?> clazz;

        public ClassConnectionSource(ConnectionSource connectionSource, Class<?> clazz) {
            this.connectionSource = connectionSource;
            this.clazz = clazz;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.clazz.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClassConnectionSource other = (ClassConnectionSource)obj;
            if (!this.clazz.equals(other.clazz)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }
}

