/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.gson.internal.sql;

import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import ru.easydonate.easypayments.libs.gson.Gson;
import ru.easydonate.easypayments.libs.gson.JsonSyntaxException;
import ru.easydonate.easypayments.libs.gson.TypeAdapter;
import ru.easydonate.easypayments.libs.gson.TypeAdapterFactory;
import ru.easydonate.easypayments.libs.gson.reflect.TypeToken;
import ru.easydonate.easypayments.libs.gson.stream.JsonReader;
import ru.easydonate.easypayments.libs.gson.stream.JsonToken;
import ru.easydonate.easypayments.libs.gson.stream.JsonWriter;

final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

