/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http.request;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.http.Headers;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public final class SimpleEasyHttpRequest
implements EasyHttpRequest {
    private final HttpClient client;
    private final HttpClient.Method method;
    private final String apiEndpoint;
    private final String apiPath;
    private final String url;
    private final QueryParams queryParams;
    private final Headers headers;
    private final String body;

    @NotNull
    static RequestBuilder builder(@NotNull HttpClient client, @NotNull HttpClient.Method method) {
        Validate.notNull(client, "client");
        Validate.notNull((Object)method, "method");
        return new RequestBuilder(client, method);
    }

    @Override
    @NotNull
    public EasyHttpResponse execute() throws HttpRequestException {
        return this.client.execute(this);
    }

    @Override
    @NotNull
    public CompletableFuture<EasyHttpResponse> executeAsync() throws HttpRequestException {
        return this.client.executeAsync(this);
    }

    @Override
    public boolean hasBody() {
        return this.body != null;
    }

    @Override
    @NotNull
    public String resolveUrl() throws HttpRequestException {
        String resolvedUrl;
        if (this.url != null) {
            resolvedUrl = this.url;
        } else if (this.apiEndpoint != null) {
            resolvedUrl = this.apiEndpoint + (this.apiPath != null ? this.apiPath : "");
        } else {
            throw new HttpRequestException("Cannot resolve a request URL with current parameters set!");
        }
        if (this.queryParams != null && !resolvedUrl.contains("?")) {
            resolvedUrl = resolvedUrl + this.queryParams.getAsString();
        }
        return resolvedUrl;
    }

    public HttpClient getClient() {
        return this.client;
    }

    @Override
    public HttpClient.Method getMethod() {
        return this.method;
    }

    @Override
    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    @Override
    public String getApiPath() {
        return this.apiPath;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public QueryParams getQueryParams() {
        return this.queryParams;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    private SimpleEasyHttpRequest(HttpClient client, HttpClient.Method method, String apiEndpoint, String apiPath, String url, QueryParams queryParams, Headers headers, String body) {
        this.client = client;
        this.method = method;
        this.apiEndpoint = apiEndpoint;
        this.apiPath = apiPath;
        this.url = url;
        this.queryParams = queryParams;
        this.headers = headers;
        this.body = body;
    }

    private static final class RequestBuilder
    implements EasyHttpRequest.Builder {
        private final HttpClient client;
        private final HttpClient.Method method;
        private String apiEndpoint;
        private String apiPath;
        private String url;
        private QueryParams queryParams;
        private Headers headers;
        private String body;

        @Override
        @NotNull
        public EasyHttpRequest build() {
            return new SimpleEasyHttpRequest(this.client, this.method, this.apiEndpoint, this.apiPath, this.url, this.queryParams, this.headers, this.body);
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setApiEndpoint(@NotNull String apiEndpoint) {
            Validate.notEmpty(apiEndpoint, "apiEndpoint");
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setApiPath(@NotNull String apiPath, Object ... args) {
            Validate.notNull(apiPath, "apiPath");
            this.apiPath = String.format(apiPath, args);
            return this;
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setUrl(@NotNull String url, Object ... args) {
            Validate.notEmpty(url, "url");
            this.url = String.format(url, args);
            return this;
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setQueryParams(@Nullable QueryParams queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setHeaders(@Nullable Headers headers) {
            this.headers = headers;
            return this;
        }

        @Override
        @NotNull
        public EasyHttpRequest.Builder setBody(@Nullable String postBody) {
            this.body = postBody;
            return this;
        }

        private RequestBuilder(HttpClient client, HttpClient.Method method) {
            this.client = client;
            this.method = method;
        }
    }
}

