/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http.request;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.http.Headers;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.SimpleEasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;

public interface EasyHttpRequest {
    @NotNull
    public static Builder builder(@NotNull HttpClient client, @NotNull HttpClient.Method method) {
        return SimpleEasyHttpRequest.builder(client, method);
    }

    @NotNull
    public EasyHttpResponse execute() throws HttpRequestException;

    @NotNull
    public CompletableFuture<EasyHttpResponse> executeAsync() throws HttpRequestException;

    @NotNull
    public HttpClient.Method getMethod();

    @Nullable
    public String getApiEndpoint();

    @Nullable
    public String getApiPath();

    @Nullable
    public String getUrl();

    @Nullable
    public QueryParams getQueryParams();

    @Nullable
    public Headers getHeaders();

    @Nullable
    public String getBody();

    public boolean hasBody();

    @NotNull
    public String resolveUrl() throws HttpRequestException;

    public static interface Builder {
        @NotNull
        public EasyHttpRequest build();

        @NotNull
        public Builder setApiEndpoint(@NotNull String var1);

        @NotNull
        public Builder setApiPath(@NotNull String var1, Object ... var2);

        @NotNull
        public Builder setUrl(@NotNull String var1, Object ... var2);

        @NotNull
        public Builder setQueryParams(@Nullable QueryParams var1);

        @NotNull
        public Builder setHeaders(@Nullable Headers var1);

        @NotNull
        public Builder setBody(@Nullable String var1);
    }
}

