/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http.client;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public abstract class AbstractHttpClient
implements HttpClient {
    protected final String apiEndpoint;
    protected final String userAgent;
    protected final HttpClient.Timeouts timeouts;

    public AbstractHttpClient(@NotNull String userAgent, @NotNull HttpClient.Timeouts timeouts, @Nullable String apiEndpoint) {
        Validate.notEmpty(userAgent, "userAgent");
        Validate.notNull(timeouts, "timeouts");
        this.apiEndpoint = apiEndpoint;
        this.userAgent = userAgent;
        this.timeouts = timeouts;
    }

    @Override
    @NotNull
    public Optional<String> getApiEndpoint() {
        return Optional.ofNullable(this.apiEndpoint);
    }

    @Override
    @NotNull
    public EasyHttpRequest.Builder createRequest(@NotNull HttpClient.Method method) {
        EasyHttpRequest.Builder builder = EasyHttpRequest.builder(this, method);
        if (this.apiEndpoint != null) {
            builder.setApiEndpoint(this.apiEndpoint);
        }
        return builder;
    }

    @Override
    @NotNull
    public EasyHttpResponse execute(@NotNull EasyHttpRequest httpRequest) throws HttpRequestException {
        return this.executeAsync(httpRequest).join();
    }

    @Override
    @NotNull
    public CompletableFuture<EasyHttpResponse> executeAsync(@NotNull EasyHttpRequest httpRequest) throws HttpRequestException {
        CompletableFuture<EasyHttpResponse> future = new CompletableFuture<EasyHttpResponse>();
        CompletableFuture.runAsync(() -> {
            try {
                future.complete(this.execute(httpRequest));
            }
            catch (HttpRequestException ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public HttpClient.Timeouts getTimeouts() {
        return this.timeouts;
    }
}

