/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.http;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryParams {
    public static final QueryParams EMPTY = new QueryParams(Collections.emptyMap());
    private final Map<String, String> queryParamsMap;

    public QueryParams() {
        this(new LinkedHashMap<String, String>());
    }

    private QueryParams(Map<String, String> queryParamsMap) {
        this.queryParamsMap = queryParamsMap;
    }

    @NotNull
    public QueryParams copy() {
        return new QueryParams(new LinkedHashMap<String, String>(this.queryParamsMap));
    }

    @NotNull
    public QueryParams add(@NotNull String key, @Nullable Object value) {
        return this.add(key, value, false);
    }

    @NotNull
    public QueryParams add(@NotNull String key, @Nullable Object value, boolean encode) {
        try {
            String encodedValue = encode ? URLEncoder.encode(String.valueOf(value), "UTF-8") : String.valueOf(value);
            this.queryParamsMap.compute(key, (k, v) -> v != null ? v + "," + encodedValue : encodedValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    public QueryParams set(@NotNull String key, @Nullable Object value) {
        return this.set(key, value, false);
    }

    @NotNull
    public QueryParams set(@NotNull String key, @Nullable Object value, boolean encode) {
        try {
            String encodedValue = encode ? URLEncoder.encode(String.valueOf(value), "UTF-8") : String.valueOf(value);
            this.queryParamsMap.put(key, encodedValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    public Map<String, String> getAsMap() {
        return this.queryParamsMap;
    }

    @NotNull
    public String getAsString() {
        if (this.queryParamsMap.isEmpty()) {
            return "";
        }
        return "?" + this.queryParamsMap.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }
}

