/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.gson.purchase;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.gson.purchase.AdditionalFieldModel;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.purchase.AdditionalField;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.purchase.Discounts;
import ru.easydonate.easypayments.libs.easydonate4j.callback.data.model.purchase.PurchasedProduct;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.JsonAdapter;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=PurchasedProduct.class)
public class PurchasedProductModel
implements PurchasedProduct {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="cost")
    private double price;
    @SerializedName(value="count")
    private long boughtAmount;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="image")
    private String iconImage;
    @SerializedName(value="commands")
    private List<String> commands;
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=AdditionalFieldModel.ListDeserializer.class)
    private List<AdditionalField> additionalFields;
    @SerializedName(value="sales")
    private Discounts discounts;

    @NotNull
    public Optional<String> getDescription() {
        return Wrapper.wrapNullable(this.description);
    }

    @NotNull
    public Optional<Discounts> getDiscounts() {
        return Wrapper.wrapNullable(this.discounts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurchasedProductModel that = (PurchasedProductModel)o;
        return this.id == that.id && Double.compare(that.price, this.price) == 0 && this.boughtAmount == that.boughtAmount && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.iconImage, that.iconImage) && Objects.equals(this.commands, that.commands) && Objects.equals(this.additionalFields, that.additionalFields) && Objects.equals(this.discounts, that.discounts);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.price, this.boughtAmount, this.description, this.iconImage, this.commands, this.additionalFields, this.discounts);
    }

    @NotNull
    public String toString() {
        return "PurchasedProductModel{id=" + this.id + ", name='" + this.name + '\'' + ", price=" + this.price + ", boughtAmount=" + this.boughtAmount + ", description='" + this.description + '\'' + ", iconImage='" + this.iconImage + '\'' + ", commands=" + this.commands + ", additionalFields=" + this.additionalFields + ", discounts=" + this.discounts + '}';
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getPrice() {
        return this.price;
    }

    public long getBoughtAmount() {
        return this.boughtAmount;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public List<AdditionalField> getAdditionalFields() {
        return this.additionalFields;
    }
}

