/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.response;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.ApiResponseFailureException;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.UnknownApiResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ApiResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ErrorResponse;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.JsonSerializationException;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleRegistrator;

public final class ResponseContentDeserializer {
    @NotNull
    public static <T> T deserializeResponseContent(@NotNull Class<? extends ApiResponse<T>> responseObjectType, @NotNull EasyHttpResponse httpResponse) throws HttpResponseException {
        String content = httpResponse.getContent();
        JsonSerializationService serializationService = ModuleRegistrator.jsonSerializationService();
        try {
            ApiResponse<T> apiResponse = serializationService.deserialize(responseObjectType, content);
            if (apiResponse.isSuccess()) {
                return apiResponse.getContent();
            }
        }
        catch (JsonSerializationException apiResponse) {
            // empty catch block
        }
        try {
            ErrorResponse errorResponse = serializationService.deserialize(ErrorResponse.class, content);
            throw new ApiResponseFailureException(httpResponse, errorResponse);
        }
        catch (JsonSerializationException ex) {
            throw new UnknownApiResponseException(httpResponse, (Throwable)ex);
        }
    }
}

