/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.client.EasyDonateClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending.PendingPayment;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.JsonSerializationException;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public final class PendingPaymentBuilder {
    private final EasyDonateClient client;
    private final Map<String, Integer> products;
    private String customer;
    private Integer serverId;
    private String email;
    private String coupon;
    private String redirectUrl;

    public PendingPaymentBuilder(@NotNull EasyDonateClient client) {
        Validate.notNull(client, "client");
        this.client = client;
        this.products = new LinkedHashMap<String, Integer>();
    }

    @NotNull
    public EasyDonateClient getClient() {
        return this.client;
    }

    @NotNull
    public PendingPayment create() throws HttpRequestException, HttpResponseException {
        return this.client.createPayment(this);
    }

    @NotNull
    public QueryParams toQueryParams() {
        QueryParams queryParams = new QueryParams();
        try {
            if (this.customer != null) {
                queryParams.set("customer", this.customer);
            }
            if (this.serverId != null) {
                queryParams.set("server_id", this.serverId);
            }
            if (this.products != null) {
                queryParams.set("products", this.client.getJsonSerialization().serialize(this.products));
            }
            if (this.email != null) {
                queryParams.set("email", this.email);
            }
            if (this.coupon != null) {
                queryParams.set("coupon", this.coupon);
            }
            if (this.redirectUrl != null) {
                queryParams.set("success_url", this.redirectUrl);
            }
        }
        catch (JsonSerializationException jsonSerializationException) {
            // empty catch block
        }
        return queryParams;
    }

    @NotNull
    public PendingPaymentBuilder setCustomer(@NotNull String customer) {
        Validate.notNull(customer, "customer");
        this.customer = customer;
        return this;
    }

    @NotNull
    public PendingPaymentBuilder setServerId(int serverId) {
        Validate.isTrue(serverId > 0, "'serverId' must be greater than 0!", new Object[0]);
        this.serverId = serverId;
        return this;
    }

    @NotNull
    public PendingPaymentBuilder addProduct(int productId) {
        return this.addProduct(productId, 1);
    }

    @NotNull
    public PendingPaymentBuilder addProduct(int productId, int amount) {
        Validate.isTrue(productId > 0, "'productId' must be greater than 0!", new Object[0]);
        Validate.isTrue(amount > 0, "'amount' must be greater than 0!", new Object[0]);
        this.products.compute(String.valueOf(productId), (key, value) -> value != null ? value + amount : amount);
        return this;
    }

    @NotNull
    public PendingPaymentBuilder setProducts(@NotNull Map<String, Integer> products) {
        Validate.notEmpty(products, "products");
        this.products.clear();
        this.products.putAll(products);
        return this;
    }

    @NotNull
    public PendingPaymentBuilder removeProduct(int productId) {
        Validate.isTrue(productId > 0, "'productId' must be greater than 0!", new Object[0]);
        this.products.remove(String.valueOf(productId));
        return this;
    }

    @NotNull
    public PendingPaymentBuilder setEmail(@NotNull String email) {
        Validate.notNull(email, "email");
        this.email = email;
        return this;
    }

    @NotNull
    public PendingPaymentBuilder setCoupon(@NotNull String coupon) {
        Validate.notNull(coupon, "coupon");
        this.coupon = coupon;
        return this;
    }

    @NotNull
    public PendingPaymentBuilder setRedirectUrl(@NotNull String redirectUrl) {
        Validate.notNull(redirectUrl, "redirectUrl");
        this.redirectUrl = redirectUrl;
        return this;
    }

    @NotNull
    public String toString() {
        return "PendingPaymentBuilder{, customer='" + this.customer + '\'' + ", serverId=" + this.serverId + ", products=" + this.products + ", email='" + this.email + '\'' + ", coupon='" + this.coupon + '\'' + ", redirectUrl='" + this.redirectUrl + '\'' + '}';
    }
}

