/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment;

import org.jetbrains.annotations.NotNull;

public enum PaymentSystem {
    INTER_KASSA("Interkassa"),
    PAY_MASTER("PayMaster"),
    QIWI("Qiwi"),
    TEST_MODE("test"),
    UNKNOWN("unknown");

    private final String key;

    @NotNull
    public static PaymentSystem getByKey(@NotNull String key) {
        if (key == null) {
            return UNKNOWN;
        }
        for (PaymentSystem paymentSystem : PaymentSystem.values()) {
            if (!paymentSystem.getKey().equalsIgnoreCase(key)) continue;
            return paymentSystem;
        }
        return UNKNOWN;
    }

    public String getKey() {
        return this.key;
    }

    private PaymentSystem(String key) {
        this.key = key;
    }
}

