/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop;

import java.time.LocalDateTime;
import java.util.Optional;
import java.util.OptionalDouble;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.DeliveryModeType;
import ru.easydonate.easypayments.libs.easydonate4j.data.model.PrettyPrintable;

public interface Shop
extends PrettyPrintable {
    public int getId();

    @NotNull
    public String getName();

    @NotNull
    public String getDomain();

    @NotNull
    public String getLastDomain();

    public boolean isActive();

    @Deprecated
    public boolean isPremium();

    public boolean isVerified();

    @NotNull
    public LocalDateTime getCreatedAt();

    @NotNull
    public LocalDateTime getUpdatedAt();

    @NotNull
    public DeliveryMode deliveryMode();

    @NotNull
    public TestMode testMode();

    @NotNull
    public Copyright copyright();

    @NotNull
    public FunctionalTab functionalTab();

    @NotNull
    public ImagesTab imagesTab();

    @NotNull
    public LinksTab linksTab();

    @NotNull
    public CustomizationTab customizationTab();

    @NotNull
    public Extra extra();

    public static enum ParticlesType {
        SNOW("snow"),
        RAIN("rain"),
        AUTUMN("autumn"),
        NOTHING("none"),
        UNKNOWN("unknown");

        @NotNull
        private final String key;

        @NotNull
        public static ParticlesType getByKey(@Nullable String key) {
            if (key == null || key.isEmpty()) {
                return UNKNOWN;
            }
            for (ParticlesType particlesType : ParticlesType.values()) {
                if (!particlesType.getKey().equalsIgnoreCase(key)) continue;
                return particlesType;
            }
            return UNKNOWN;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        private ParticlesType(String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
        }
    }

    public static interface Extra {
        public int getGameId();

        public int getUserId();

        @NotNull
        public String getAccessKey();

        @NotNull
        public OptionalDouble getRating();

        @Nullable
        public Double getRatingRaw();
    }

    public static interface CustomizationTab {
        @NotNull
        public Optional<String> getDescription();

        @NotNull
        public String getAccentColor();

        public int getThemeId();

        public boolean isUsesBackgroundOverlay();

        public boolean isSideImageHidden();

        public boolean isProductImagePaddingsEnabled();

        public boolean isServersHidden();

        public boolean isTotalOnlineHidden();

        @NotNull
        public ParticlesType getParticlesType();

        @NotNull
        public String getParticlesTypeRaw();

        @NotNull
        public Optional<String> getCustomCSS();

        @NotNull
        public String getPaymentInstruction();

        public boolean isPaymentInstructionHidden();
    }

    public static interface LinksTab {
        @NotNull
        public Optional<String> getVKontakteLink();

        @NotNull
        public Optional<String> getYouTubeLink();

        @NotNull
        public Optional<String> getDiscordLink();

        @NotNull
        public Optional<String> getTwitchLink();

        @NotNull
        public Optional<String> getInstagramLink();

        @NotNull
        public Optional<String> getTikTokLink();
    }

    public static interface ImagesTab {
        @NotNull
        public Optional<String> getFaviconImage();

        @NotNull
        public Optional<String> getLogoImage();

        @NotNull
        public Optional<String> getBackgroundImage();

        @NotNull
        public Optional<String> getSideImage();
    }

    public static interface FunctionalTab {
        public boolean isPaymentComissionAssignedToShop();

        public boolean isEmailRequired();

        public boolean isUsesShopCart();

        public boolean isSpacesAllowedInNickNames();

        public boolean isHttpsRedirectEnabled();
    }

    public static interface Copyright {
        public boolean isHidden();

        @NotNull
        public Optional<LocalDateTime> getHiddenUntil();
    }

    public static interface TestMode {
        public boolean isEnabled();

        @NotNull
        public Optional<String> getWhoEnabled();
    }

    public static interface DeliveryMode {
        @NotNull
        public DeliveryModeType getType();

        @NotNull
        public String getTypeRaw();

        public boolean isPluginInstalled();
    }
}

