/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ProductType {
    ITEM("item"),
    PRIVILEGE("group"),
    CURRENCY("currency"),
    CASE("case"),
    OTHER("other"),
    UNKNOWN("unknown");

    @NotNull
    private final String key;

    @NotNull
    public static ProductType getByKey(@Nullable String key) {
        if (key == null || key.isEmpty()) {
            return UNKNOWN;
        }
        for (ProductType productType : ProductType.values()) {
            if (!productType.getKey().equalsIgnoreCase(key)) continue;
            return productType;
        }
        return UNKNOWN;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    private ProductType(String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
    }
}

