/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin;

import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.Plugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.last.purchases.LastPaymentsPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargePlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.yandex.metrika.YandexMetrikaPlugin;

public enum PluginType {
    SURCHARGE("EasyDonate", "Surcharge", "easydonate/surcharge", SurchargePlugin.class),
    LAST_PAYMENTS("EasyDonate", "LastPayments", "easydonate/last-payments", LastPaymentsPlugin.class),
    CUSTOM_MESSAGES("EasyDonate", "CustomMessages", "easydonate/custom-messages", Plugin.class),
    DISCORD_WIDGET("Discord", "Widget", "discord/widget", Plugin.class),
    VK_NEWS("Vkontakte", "News", "vkontakte/news", Plugin.class),
    VK_COMMUNITY_WIDGET("Vkontakte", "Widget", "vkontakte/community-widget", Plugin.class),
    VK_MESSAGES_WIDGET("Vkontakte", "MessagesWidget", "vkontakte/messages-widget", Plugin.class),
    YANDEX_METRIKA("Yandex", "Metrika", "yandex/metrika", YandexMetrikaPlugin.class);

    private final String provider;
    private final String name;
    private final String testingJsonResourceName;
    private final Class<? extends Plugin> pluginClass;

    @NotNull
    public String getApiName() {
        return String.format("%s.%s", this.provider, this.name);
    }

    @NotNull
    public String toString() {
        return "PluginType{provider=" + this.provider + ", name='" + this.name + '\'' + ", testingJsonResourceName='" + this.testingJsonResourceName + '\'' + ", pluginClass=" + this.pluginClass + '}';
    }

    public String getProvider() {
        return this.provider;
    }

    public String getName() {
        return this.name;
    }

    public String getTestingJsonResourceName() {
        return this.testingJsonResourceName;
    }

    public Class<? extends Plugin> getPluginClass() {
        return this.pluginClass;
    }

    private PluginType(String provider, String name, String testingJsonResourceName, Class<? extends Plugin> pluginClass) {
        this.provider = provider;
        this.name = name;
        this.testingJsonResourceName = testingJsonResourceName;
        this.pluginClass = pluginClass;
    }
}

