/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.payment;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.DeliveryModeType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.PaymentStatus;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.PaymentSystem;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.PaymentType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.SentCommand;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.purchase.PurchasedProduct;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.server.Server;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=Payment.class)
public class PaymentModel
implements Payment {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="shop_id")
    private int shopId;
    @SerializedName(value="customer")
    private String customer;
    @SerializedName(value="email")
    private String email;
    @SerializedName(value="status")
    private int statusRaw;
    @SerializedName(value="cost")
    private double purchaseCost;
    @SerializedName(value="enrolled")
    private double enrolledAmount;
    @SerializedName(value="income")
    private double serviceComission;
    @SerializedName(value="payment_system")
    private String paymentSystemRaw;
    @SerializedName(value="payment_type")
    private String paymentTypeRaw;
    @SerializedName(value="server_id")
    private int serverId;
    @SerializedName(value="delivery_type")
    private String deliveryTypeRaw;
    @SerializedName(value="success_url")
    private String redirectUrl;
    @SerializedName(value="error")
    private String errorMessage;
    @SerializedName(value="attempts")
    private int handleAttempts;
    @SerializedName(value="was_sent")
    private boolean wasSent;
    @SerializedName(value="rating")
    private Integer rating;
    @SerializedName(value="sent_commands")
    private List<SentCommand> sentCommands;
    @SerializedName(value="products")
    private List<PurchasedProduct> products;
    @SerializedName(value="server")
    private Server server;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @Override
    @NotNull
    public Optional<String> getEmail() {
        return Wrapper.wrapNullable(this.email);
    }

    @Override
    @NotNull
    public PaymentStatus getStatus() {
        return PaymentStatus.getByCode(this.statusRaw);
    }

    @Override
    @NotNull
    public PaymentSystem getPaymentSystem() {
        return PaymentSystem.getByKey(this.paymentSystemRaw);
    }

    @Override
    @NotNull
    public PaymentType getPaymentType() {
        return PaymentType.getByKey(this.paymentTypeRaw);
    }

    @Override
    @NotNull
    public DeliveryModeType getDeliveryType() {
        return DeliveryModeType.getByKey(this.deliveryTypeRaw);
    }

    @Override
    @NotNull
    public Optional<String> getRedirectUrl() {
        return Wrapper.wrapNullable(this.redirectUrl);
    }

    @Override
    public boolean wasSent() {
        return this.wasSent;
    }

    @Override
    @NotNull
    public OptionalInt getRating() {
        return Wrapper.wrapNullableInt(this.rating);
    }

    @Override
    @NotNull
    public Optional<String> getErrorMessage() {
        return Wrapper.wrapNullable(this.errorMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentModel that = (PaymentModel)o;
        return this.id == that.id && this.shopId == that.shopId && this.statusRaw == that.statusRaw && Double.compare(that.purchaseCost, this.purchaseCost) == 0 && Double.compare(that.enrolledAmount, this.enrolledAmount) == 0 && Double.compare(that.serviceComission, this.serviceComission) == 0 && this.serverId == that.serverId && this.handleAttempts == that.handleAttempts && this.wasSent == that.wasSent && Objects.equals(this.customer, that.customer) && Objects.equals(this.email, that.email) && Objects.equals(this.paymentSystemRaw, that.paymentSystemRaw) && Objects.equals(this.paymentTypeRaw, that.paymentTypeRaw) && Objects.equals(this.deliveryTypeRaw, that.deliveryTypeRaw) && Objects.equals(this.redirectUrl, that.redirectUrl) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.rating, that.rating) && Objects.equals(this.sentCommands, that.sentCommands) && Objects.equals(this.products, that.products) && Objects.equals(this.server, that.server) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shopId, this.customer, this.email, this.statusRaw, this.purchaseCost, this.enrolledAmount, this.serviceComission, this.paymentSystemRaw, this.paymentTypeRaw, this.serverId, this.deliveryTypeRaw, this.redirectUrl, this.errorMessage, this.handleAttempts, this.wasSent, this.rating, this.sentCommands, this.products, this.server, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "PaymentModel{id=" + this.id + ", shopId=" + this.shopId + ", customer='" + this.customer + '\'' + ", email='" + this.email + '\'' + ", statusRaw=" + this.statusRaw + ", purchaseCost=" + this.purchaseCost + ", enrolledAmount=" + this.enrolledAmount + ", serviceComission=" + this.serviceComission + ", paymentSystemRaw='" + this.paymentSystemRaw + '\'' + ", paymentTypeRaw='" + this.paymentTypeRaw + '\'' + ", serverId=" + this.serverId + ", deliveryTypeRaw='" + this.deliveryTypeRaw + '\'' + ", redirectUrl='" + this.redirectUrl + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", handleAttempts=" + this.handleAttempts + ", wasSent=" + this.wasSent + ", rating=" + this.rating + ", sentCommands=" + this.sentCommands + ", products=" + this.products + ", server=" + this.server + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getShopId() {
        return this.shopId;
    }

    @Override
    public String getCustomer() {
        return this.customer;
    }

    @Override
    public int getStatusRaw() {
        return this.statusRaw;
    }

    @Override
    public double getPurchaseCost() {
        return this.purchaseCost;
    }

    @Override
    public double getEnrolledAmount() {
        return this.enrolledAmount;
    }

    @Override
    public double getServiceComission() {
        return this.serviceComission;
    }

    @Override
    public String getPaymentSystemRaw() {
        return this.paymentSystemRaw;
    }

    @Override
    public String getPaymentTypeRaw() {
        return this.paymentTypeRaw;
    }

    @Override
    public int getServerId() {
        return this.serverId;
    }

    @Override
    public String getDeliveryTypeRaw() {
        return this.deliveryTypeRaw;
    }

    @Override
    public int getHandleAttempts() {
        return this.handleAttempts;
    }

    public boolean isWasSent() {
        return this.wasSent;
    }

    @Override
    public List<SentCommand> getSentCommands() {
        return this.sentCommands;
    }

    @Override
    public List<PurchasedProduct> getProducts() {
        return this.products;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

