/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.shop.coupon;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.coupon.Coupon;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.ProductsList;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Wrapper;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=Coupon.class)
public class CouponModel
implements Coupon {
    @SerializedName(value="id")
    private int id;
    @SerializedName(value="shop_id")
    private int shopId;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="code")
    private String code;
    @SerializedName(value="sale")
    private double discountPercent;
    @SerializedName(value="limit")
    private Integer maxUsages;
    @SerializedName(value="products")
    private ProductsList products;
    @SerializedName(value="expires_at")
    private LocalDateTime expiresAt;
    @SerializedName(value="created_at")
    private LocalDateTime createdAt;
    @SerializedName(value="updated_at")
    private LocalDateTime updatedAt;

    @Override
    @NotNull
    public OptionalInt getMaxUsages() {
        return Wrapper.wrapNullableInt(this.maxUsages);
    }

    @Override
    @NotNull
    public Optional<LocalDateTime> getExpiresAt() {
        return Wrapper.wrapNullable(this.expiresAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CouponModel that = (CouponModel)o;
        return this.id == that.id && this.shopId == that.shopId && Double.compare(that.discountPercent, this.discountPercent) == 0 && Objects.equals(this.name, that.name) && Objects.equals(this.code, that.code) && Objects.equals(this.maxUsages, that.maxUsages) && Objects.equals(this.products, that.products) && Objects.equals(this.expiresAt, that.expiresAt) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.updatedAt, that.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shopId, this.name, this.code, this.discountPercent, this.maxUsages, this.products, this.expiresAt, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "CouponModel{id=" + this.id + ", shopId=" + this.shopId + ", name='" + this.name + '\'' + ", code='" + this.code + '\'' + ", discountPercent=" + this.discountPercent + ", maxUsages=" + this.maxUsages + ", products=" + this.products + ", expiresAt=" + this.expiresAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getShopId() {
        return this.shopId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public double getDiscountPercent() {
        return this.discountPercent;
    }

    @Override
    public ProductsList getProducts() {
        return this.products;
    }

    @Override
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

