/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.gson.plugin.easydonate.surcharge;

import java.util.Objects;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargePluginSettings;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.ProductType;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.Implementing;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;
import ru.easydonate.easypayments.libs.gson.annotations.SerializedName;

@Implementing(value=SurchargePluginSettings.class)
public class SurchargePluginSettingsModel
implements SurchargePluginSettings {
    @SerializedName(value="enabled")
    private boolean enabled;
    @SerializedName(value="disallow_with_promocodes")
    private boolean disallowedWithPromocodes;
    @SerializedName(value="duration")
    private int availabilityDuration;
    @SerializedName(value="enableForGroup")
    private boolean availableForPrivileges;
    @SerializedName(value="enableForItem")
    private boolean availableForItems;
    @SerializedName(value="enableForCurrency")
    private boolean availableForCurrencies;
    @SerializedName(value="enableForOther")
    private boolean availableForOthers;

    @Override
    @NotNull
    public OptionalInt getAvailabilityDuration() {
        return this.availabilityDuration > 0 ? OptionalInt.of(this.availabilityDuration) : OptionalInt.empty();
    }

    @Override
    public boolean isAvailableFor(@NotNull ProductType productType) {
        Validate.notNull((Object)productType, "productType");
        switch (productType) {
            case PRIVILEGE: {
                return this.availableForPrivileges;
            }
            case ITEM: {
                return this.availableForItems;
            }
            case CURRENCY: {
                return this.availableForCurrencies;
            }
            case OTHER: {
                return this.availableForOthers;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SurchargePluginSettingsModel that = (SurchargePluginSettingsModel)o;
        return this.enabled == that.enabled && this.disallowedWithPromocodes == that.disallowedWithPromocodes && this.availabilityDuration == that.availabilityDuration && this.availableForPrivileges == that.availableForPrivileges && this.availableForItems == that.availableForItems && this.availableForCurrencies == that.availableForCurrencies && this.availableForOthers == that.availableForOthers;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.disallowedWithPromocodes, this.availabilityDuration, this.availableForPrivileges, this.availableForItems, this.availableForCurrencies, this.availableForOthers);
    }

    @NotNull
    public String toString() {
        return "SurchargePluginSettingsModel{enabled=" + this.enabled + ", disallowedWithPromocodes=" + this.disallowedWithPromocodes + ", availabilityDuration=" + this.availabilityDuration + ", availableForPrivileges=" + this.availableForPrivileges + ", availableForItems=" + this.availableForItems + ", availableForCurrencies=" + this.availableForCurrencies + ", availableForOthers=" + this.availableForOthers + '}';
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isDisallowedWithPromocodes() {
        return this.disallowedWithPromocodes;
    }

    @Override
    public boolean isAvailableForPrivileges() {
        return this.availableForPrivileges;
    }

    @Override
    public boolean isAvailableForItems() {
        return this.availableForItems;
    }

    @Override
    public boolean isAvailableForCurrencies() {
        return this.availableForCurrencies;
    }

    @Override
    public boolean isAvailableForOthers() {
        return this.availableForOthers;
    }
}

