/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.libs.easydonate4j.api.v3.client;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.client.EasyDonateClient;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.PluginManager;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.PluginType;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.discord.widget.DiscordWidgetPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.custom.messages.CustomMessagesPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.last.purchases.LastPaymentsPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.easydonate.surcharge.SurchargePlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.vkontakte.community.widget.VKCommunityWidgetPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.vkontakte.messages.widget.VKMessagesWidgetPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.vkontakte.news.VKNewsPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.plugin.yandex.metrika.YandexMetrikaPlugin;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.ActivityFlag;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.Shop;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.coupon.CouponsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.mass.sale.MassSalesList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.Payment;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.PaymentsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending.PendingPayment;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.payment.pending.PendingPaymentBuilder;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.Product;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.product.ProductsList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.server.Server;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.data.model.shop.server.ServersList;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.exception.HttpResponseFailureException;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ApiResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.ResponseContentDeserializer;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.plugin.PluginApiResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.CreatePaymentResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetCouponsListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetMassSalesListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetPaymentResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetPaymentsListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetProductResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetProductsListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetServerResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetServersListResponse;
import ru.easydonate.easypayments.libs.easydonate4j.api.v3.response.shop.GetShopResponse;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpRequestException;
import ru.easydonate.easypayments.libs.easydonate4j.exception.HttpResponseException;
import ru.easydonate.easypayments.libs.easydonate4j.http.Headers;
import ru.easydonate.easypayments.libs.easydonate4j.http.QueryParams;
import ru.easydonate.easypayments.libs.easydonate4j.http.client.HttpClient;
import ru.easydonate.easypayments.libs.easydonate4j.http.request.EasyHttpRequest;
import ru.easydonate.easypayments.libs.easydonate4j.http.response.EasyHttpResponse;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.JsonSerializationService;
import ru.easydonate.easypayments.libs.easydonate4j.json.serialization.implementation.registry.JsonModelsGroup;
import ru.easydonate.easypayments.libs.easydonate4j.module.ModuleRegistrator;
import ru.easydonate.easypayments.libs.easydonate4j.util.Validate;

public class SimpleEasyDonateClient
implements EasyDonateClient {
    public static final String API_ENDPOINT = "https://easydonate.ru/api/v3";
    protected final String accessKey;
    protected final PluginManager pluginManager;
    protected final Headers defaultHeaders;
    protected final HttpClient httpClient;
    protected final JsonSerializationService jsonSerialization;

    protected SimpleEasyDonateClient(@NotNull String accessKey, @NotNull String userAgent, long connectTimeout, long responseTimeout, long readTimeout, long writeTimeout) {
        Validate.notEmpty(accessKey, "accessKey");
        Validate.notEmpty(userAgent, "userAgent");
        this.accessKey = accessKey;
        this.pluginManager = new SimplePluginManager(this);
        this.defaultHeaders = new Headers().add("Accept-Charset", StandardCharsets.UTF_8.name()).add("Shop-Key", accessKey).add("User-Agent", userAgent);
        this.httpClient = ModuleRegistrator.httpClientService().buildClient().setApiEndpoint(API_ENDPOINT).setConnectTimeout(connectTimeout).setResponseTimeout(responseTimeout).setReadTimeout(readTimeout).setWriteTimeout(writeTimeout).setUserAgent(userAgent).create();
        this.jsonSerialization = ModuleRegistrator.jsonSerializationService();
        this.jsonSerialization.registerImplementationAliasesGroup(JsonModelsGroup.API_V3_MODELS);
    }

    @Override
    @NotNull
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    @NotNull
    public Shop getShop() throws HttpRequestException, HttpResponseException {
        return (Shop)this.executeShopRequest(GetShopResponse.class, "/shop", new Object[0]);
    }

    @Override
    @NotNull
    public Product getProduct(int productId) throws HttpRequestException, HttpResponseException {
        Validate.isTrue(productId > 0, "'productId' must be greater than 0!", new Object[0]);
        return (Product)this.executeShopRequest(GetProductResponse.class, "/shop/product/%d", productId);
    }

    @Override
    @NotNull
    public ProductsList getProductsList() throws HttpRequestException, HttpResponseException {
        return (ProductsList)this.executeShopRequest(GetProductsListResponse.class, "/shop/products", new Object[0]);
    }

    @Override
    @NotNull
    public Server getServer(int serverId) throws HttpRequestException, HttpResponseException {
        Validate.isTrue(serverId > 0, "'serverId' must be greater than 0!", new Object[0]);
        return (Server)this.executeShopRequest(GetServerResponse.class, "/shop/server/%d", serverId);
    }

    @Override
    @NotNull
    public ServersList getServersList() throws HttpRequestException, HttpResponseException {
        return (ServersList)this.executeShopRequest(GetServersListResponse.class, "/shop/servers", new Object[0]);
    }

    @Override
    @NotNull
    public MassSalesList getMassSalesList() throws HttpRequestException, HttpResponseException {
        return this.getMassSalesList(ActivityFlag.ALL);
    }

    @Override
    @NotNull
    public MassSalesList getMassSalesList(@NotNull ActivityFlag activityFlag) throws HttpRequestException, HttpResponseException {
        Validate.notNull((Object)activityFlag, "activityFlag");
        QueryParams queryParams = activityFlag.addAsQueryParameter(new QueryParams());
        return (MassSalesList)this.executeShopRequest(GetMassSalesListResponse.class, "/shop/massSales", queryParams, new Object[0]);
    }

    @Override
    @NotNull
    public CouponsList getCouponsList() throws HttpRequestException, HttpResponseException {
        return this.getCouponsList(ActivityFlag.ALL);
    }

    @Override
    @NotNull
    public CouponsList getCouponsList(@NotNull ActivityFlag activityFlag) throws HttpRequestException, HttpResponseException {
        Validate.notNull((Object)activityFlag, "activityFlag");
        QueryParams queryParams = activityFlag.addAsQueryParameter(new QueryParams());
        return (CouponsList)this.executeShopRequest(GetCouponsListResponse.class, "/shop/coupons", queryParams, new Object[0]);
    }

    @Override
    @NotNull
    public Payment getPayment(int paymentId) throws HttpRequestException, HttpResponseException {
        Validate.isTrue(paymentId > 0, "'paymentId' must be greater than 0!", new Object[0]);
        return (Payment)this.executeShopRequest(GetPaymentResponse.class, "/shop/payment/%d", paymentId);
    }

    @Override
    @NotNull
    public PaymentsList getPaymentsList() throws HttpRequestException, HttpResponseException {
        return (PaymentsList)this.executeShopRequest(GetPaymentsListResponse.class, "/shop/payments", new Object[0]);
    }

    @Override
    @NotNull
    public PendingPaymentBuilder createPayment() {
        return new PendingPaymentBuilder(this);
    }

    @Override
    @NotNull
    public PendingPayment createPayment(@NotNull PendingPaymentBuilder paymentBuilder) throws HttpRequestException, HttpResponseException {
        Validate.notNull(paymentBuilder, "paymentBuilder");
        return (PendingPayment)this.executeShopRequest(CreatePaymentResponse.class, "/shop/payment/create", paymentBuilder.toQueryParams(), new Object[0]);
    }

    @NotNull
    protected <T> T executeShopRequest(@NotNull Class<? extends ApiResponse<T>> responseType, @NotNull String apiPath, Object ... pathArgs) throws HttpRequestException, HttpResponseException {
        return this.executeShopRequest(responseType, apiPath, null, pathArgs);
    }

    @NotNull
    protected <T> T executeShopRequest(@NotNull Class<? extends ApiResponse<T>> responseType, @NotNull String apiPath, @Nullable QueryParams queryParams, Object ... pathArgs) throws HttpRequestException, HttpResponseException {
        EasyHttpRequest httpRequest = this.createRequest(HttpClient.Method.GET).setApiPath(apiPath, pathArgs).setHeaders(this.defaultHeaders).setQueryParams(queryParams).build();
        return this.request(responseType, httpRequest);
    }

    @NotNull
    protected <T> T executePluginRequest(@NotNull Class<? extends ApiResponse<T>> responseType, @NotNull Headers headers, @Nullable QueryParams queryParams) throws HttpRequestException, HttpResponseException {
        Validate.notNull(responseType, "responseType");
        Validate.notNull(headers, "headers");
        PluginApiResponse annotation = responseType.getAnnotation(PluginApiResponse.class);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("A response type '%s' isn't annotated by the @PluginApiResponse!", responseType.getName()));
        }
        PluginType pluginType = annotation.pluginType();
        String apiMethod = annotation.apiMethod();
        EasyHttpRequest httpRequest = this.createRequest(HttpClient.Method.GET).setApiPath("/plugin/%s/%s", pluginType.getApiName(), apiMethod).setHeaders(headers).setQueryParams(queryParams).build();
        return this.request(responseType, httpRequest);
    }

    @Override
    @NotNull
    public <T> T request(@NotNull Class<? extends ApiResponse<T>> responseObjectType, @NotNull EasyHttpRequest httpRequest) throws HttpRequestException, HttpResponseException {
        Validate.notNull(responseObjectType, "responseObjectType");
        Validate.notNull(httpRequest, "httpRequest");
        EasyHttpResponse httpResponse = this.httpClient.execute(httpRequest);
        if (httpResponse.isSuccess()) {
            return ResponseContentDeserializer.deserializeResponseContent(responseObjectType, httpResponse);
        }
        throw new HttpResponseFailureException(httpResponse);
    }

    @Override
    @NotNull
    public <T> CompletableFuture<T> requestAsync(@NotNull Class<? extends ApiResponse<T>> responseObjectType, @NotNull EasyHttpRequest httpRequest) {
        Validate.notNull(responseObjectType, "responseObjectType");
        Validate.notNull(httpRequest, "httpRequest");
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                future.complete(this.request(responseObjectType, httpRequest));
            }
            catch (HttpRequestException | HttpResponseException ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public EasyHttpRequest.Builder createRequest(@NotNull HttpClient.Method method) {
        Validate.notNull((Object)method, "method");
        return this.httpClient.createRequest(method);
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Headers getDefaultHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public JsonSerializationService getJsonSerialization() {
        return this.jsonSerialization;
    }

    public static final class SimplePluginManager
    implements PluginManager {
        private final SimpleEasyDonateClient client;

        private SimplePluginManager(@NotNull SimpleEasyDonateClient client) {
            this.client = client;
        }

        @Override
        @NotNull
        public SurchargePlugin getSurchargePlugin() {
            return new SurchargePlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public LastPaymentsPlugin getLastPaymentsPlugin() {
            return new LastPaymentsPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public CustomMessagesPlugin getCustomMessagesPlugin() {
            return new CustomMessagesPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public DiscordWidgetPlugin getDiscordWidgetPlugin() {
            return new DiscordWidgetPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public VKCommunityWidgetPlugin getVKCommunityWidgetPlugin() {
            return new VKCommunityWidgetPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public VKMessagesWidgetPlugin getVKMessagesWidgetPlugin() {
            return new VKMessagesWidgetPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public VKNewsPlugin getVKNewsPlugin() {
            return new VKNewsPlugin(this.client, this::executePluginRequestSafely);
        }

        @Override
        @NotNull
        public YandexMetrikaPlugin getYandexMetrikaPlugin() {
            return new YandexMetrikaPlugin(this.client, this::executePluginRequestSafely);
        }

        @NotNull
        public <T> T executePluginRequestSafely(@NotNull Class<? extends ApiResponse<T>> responseType, @Nullable QueryParams queryParams) throws HttpRequestException, HttpResponseException {
            return this.client.executePluginRequest(responseType, this.client.defaultHeaders, queryParams);
        }

        @Override
        public SimpleEasyDonateClient getClient() {
            return this.client;
        }
    }

    static final class SimpleBuilder
    implements EasyDonateClient.Builder {
        private String accessKey;
        private String userAgent = "EasyDonate4J";
        private long connectTimeout = 5000L;
        private long responseTimeout = 5000L;
        private long readTimeout = 5000L;
        private long writeTimeout = 5000L;

        SimpleBuilder() {
        }

        @Override
        @NotNull
        public EasyDonateClient create() {
            return new SimpleEasyDonateClient(this.accessKey, this.userAgent, this.connectTimeout, this.responseTimeout, this.readTimeout, this.writeTimeout);
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setAccessKey(@NotNull String accessKey) {
            Validate.notEmpty(accessKey, "accessKey");
            this.accessKey = accessKey;
            return this;
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setConnectTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Validate.notNull((Object)timeUnit, "timeUnit");
            this.connectTimeout = timeout > 0L ? timeUnit.toMillis(timeout) : 0L;
            return this;
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setResponseTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Validate.notNull((Object)timeUnit, "timeUnit");
            this.responseTimeout = timeout > 0L ? timeUnit.toMillis(timeout) : 0L;
            return this;
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setReadTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Validate.notNull((Object)timeUnit, "timeUnit");
            this.readTimeout = timeout > 0L ? timeUnit.toMillis(timeout) : 0L;
            return this;
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setWriteTimeout(long timeout, @NotNull TimeUnit timeUnit) {
            Validate.notNull((Object)timeUnit, "timeUnit");
            this.writeTimeout = timeout > 0L ? timeUnit.toMillis(timeout) : 0L;
            return this;
        }

        @Override
        @NotNull
        public EasyDonateClient.Builder setUserAgent(@NotNull String userAgent) {
            Validate.notEmpty(userAgent, "userAgent");
            this.userAgent = userAgent;
            return this;
        }
    }
}

