/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.persister;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.libs.ormlite.field.FieldType;
import ru.easydonate.easypayments.libs.ormlite.field.SqlType;
import ru.easydonate.easypayments.libs.ormlite.field.types.StringType;

public final class LocalDateTimePersister
extends StringType {
    private static final LocalDateTimePersister SINGLETON = new LocalDateTimePersister();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    private LocalDateTimePersister() {
        super(SqlType.STRING, new Class[]{LocalDateTime.class});
    }

    @NotNull
    public static LocalDateTimePersister getSingleton() {
        return SINGLETON;
    }

    @Override
    @Nullable
    public String javaToSqlArg(@NotNull FieldType fieldType, @Nullable Object javaObject) {
        if (javaObject instanceof LocalDateTime) {
            LocalDateTime asLocalDateTime = (LocalDateTime)javaObject;
            return DATE_TIME_FORMATTER.format(asLocalDateTime);
        }
        return null;
    }

    @Override
    @Nullable
    public LocalDateTime sqlArgToJava(@NotNull FieldType fieldType, @Nullable Object sqlArg, int columnPos) {
        if (sqlArg instanceof String) {
            String asString = (String)sqlArg;
            return LocalDateTime.from(DATE_TIME_FORMATTER.parse(asString));
        }
        return null;
    }
}

