/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.model;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.PurchasedProduct;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.database.persister.JsonArrayPersister;
import ru.easydonate.easypayments.libs.ormlite.field.DatabaseField;
import ru.easydonate.easypayments.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="easypayments_purchases")
public final class Purchase {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_PAYMENT_ID = "payment_id";
    public static final String COLUMN_PRODUCT_ID = "product_id";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_AMOUNT = "amount";
    public static final String COLUMN_COST = "cost";
    public static final String COLUMN_COMMANDS = "commands";
    public static final String COLUMN_RESPONSES = "responses";
    public static final String COLUMN_CREATED_AT = "created_at";
    public static final String COLUMN_UPDATED_AT = "updated_at";
    @DatabaseField(columnName="id", generatedId=true)
    private int id;
    @DatabaseField(columnName="payment_id", foreign=true, canBeNull=false)
    private Payment payment;
    @DatabaseField(columnName="product_id", canBeNull=false)
    private int productId;
    @DatabaseField(columnName="name", canBeNull=false)
    private String name;
    @DatabaseField(columnName="amount", canBeNull=false)
    private int amount;
    @DatabaseField(columnName="cost", canBeNull=false)
    private double cost;
    @DatabaseField(columnName="commands", persisterClass=JsonArrayPersister.class)
    private List<String> commands;
    @DatabaseField(columnName="responses", persisterClass=JsonArrayPersister.class)
    private List<String> responses;
    @DatabaseField(columnName="created_at", canBeNull=false)
    private LocalDateTime createdAt;
    @DatabaseField(columnName="updated_at", canBeNull=false)
    private LocalDateTime updatedAt;

    public Purchase(@NotNull Payment payment, int productId, @NotNull String name, int amount, double cost, @Nullable List<String> commands) {
        this.payment = payment;
        this.productId = productId;
        this.name = name;
        this.amount = amount;
        this.cost = cost;
        this.commands = commands;
        this.updatedAt = this.createdAt = LocalDateTime.now();
    }

    @NotNull
    public static Purchase create(@NotNull Payment payment, @NotNull PurchasedProduct product) {
        return new Purchase(payment, product.getId(), product.getName(), product.getCount(), product.getCost(), product.getRawCommands());
    }

    @NotNull
    public static Purchase create(@NotNull Payment payment, @NotNull PurchasedProduct product, @NotNull List<CommandReport> commandReports) {
        Purchase purchase = Purchase.create(payment, product);
        purchase.collect(commandReports);
        return purchase;
    }

    @NotNull
    public List<CommandReport> constructCommandReports() {
        if (this.commands == null || this.responses == null) {
            return Collections.emptyList();
        }
        ArrayList<CommandReport> commandReports = new ArrayList<CommandReport>();
        for (int i = 0; i < this.commands.size(); ++i) {
            String command = this.commands.get(i);
            String response = this.getResponse(i, "");
            commandReports.add(CommandReport.create(command, response));
        }
        return commandReports;
    }

    @Nullable
    public String getResponse(int index, @Nullable String defaultValue) {
        if (this.responses == null || index >= this.responses.size()) {
            return defaultValue;
        }
        return this.responses.get(index);
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public boolean isCollected() {
        return this.responses != null;
    }

    public boolean collect(@NotNull List<CommandReport> commandReports) {
        if (this.isCollected()) {
            return false;
        }
        this.commands = commandReports.stream().map(CommandReport::getCommand).collect(Collectors.toList());
        this.responses = commandReports.stream().map(CommandReport::getResponse).collect(Collectors.toList());
        this.updatedAt = LocalDateTime.now();
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Purchase purchase = (Purchase)o;
        return this.id == purchase.id && this.productId == purchase.productId && this.amount == purchase.amount && Double.compare(purchase.cost, this.cost) == 0 && Objects.equals(this.payment, purchase.payment) && Objects.equals(this.name, purchase.name) && Objects.equals(this.commands, purchase.commands) && Objects.equals(this.responses, purchase.responses) && Objects.equals(this.createdAt, purchase.createdAt) && Objects.equals(this.updatedAt, purchase.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.payment, this.productId, this.name, this.amount, this.cost, this.commands, this.responses, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "Purchase{id=" + this.id + ", payment=" + this.payment + ", productId=" + this.productId + ", name='" + this.name + '\'' + ", amount=" + this.amount + ", cost=" + this.cost + ", commands=" + this.commands + ", responses=" + this.responses + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Payment getPayment() {
        return this.payment;
    }

    @Generated
    public int getProductId() {
        return this.productId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public double getCost() {
        return this.cost;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public List<String> getResponses() {
        return this.responses;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Purchase() {
    }
}

