/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.model;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.easydonate4j.extension.data.model.object.CommandReport;
import ru.easydonate.easypayments.core.easydonate4j.longpoll.data.model.object.PurchasedProduct;
import ru.easydonate.easypayments.database.model.Customer;
import ru.easydonate.easypayments.database.model.Purchase;
import ru.easydonate.easypayments.libs.ormlite.dao.ForeignCollection;
import ru.easydonate.easypayments.libs.ormlite.field.DatabaseField;
import ru.easydonate.easypayments.libs.ormlite.field.ForeignCollectionField;
import ru.easydonate.easypayments.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="easypayments_payments")
public final class Payment {
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_CUSTOMER_ID = "customer_id";
    public static final String COLUMN_SERVER_ID = "server_id";
    public static final String COLUMN_COLLECTED_AT = "collected_at";
    public static final String COLUMN_REPORTED_AT = "reported_at";
    public static final String COLUMN_CREATED_AT = "created_at";
    public static final String COLUMN_UPDATED_AT = "updated_at";
    @DatabaseField(columnName="id", id=true)
    private int id;
    @DatabaseField(columnName="customer_id", foreign=true, canBeNull=false)
    private Customer customer;
    @DatabaseField(columnName="server_id", canBeNull=false)
    private int serverId;
    @DatabaseField(columnName="collected_at")
    private LocalDateTime collectedAt;
    @DatabaseField(columnName="reported_at")
    private LocalDateTime reportedAt;
    @DatabaseField(columnName="created_at", canBeNull=false)
    private LocalDateTime createdAt;
    @DatabaseField(columnName="updated_at", canBeNull=false)
    private LocalDateTime updatedAt;
    @ForeignCollectionField
    private ForeignCollection<Purchase> purchases;

    public Payment(@NotNull Customer customer, int paymentId, int serverId) {
        this.id = paymentId;
        this.customer = customer;
        this.serverId = serverId;
        this.updatedAt = this.createdAt = LocalDateTime.now();
    }

    @NotNull
    public Purchase createPurchase(int productId, @NotNull String name, int amount, double cost, @NotNull List<String> commands) {
        return new Purchase(this, productId, name, amount, cost, commands);
    }

    @NotNull
    public Purchase createPurchase(@NotNull PurchasedProduct product) {
        return Purchase.create(this, product);
    }

    @NotNull
    public Purchase createPurchase(@NotNull PurchasedProduct product, @NotNull List<CommandReport> commandReports) {
        return Purchase.create(this, product, commandReports);
    }

    public int getPurchasesAmount() {
        return this.purchases != null ? this.purchases.size() : 0;
    }

    public boolean hasPurchases() {
        return this.getPurchasesAmount() != 0;
    }

    public boolean isCollected() {
        return this.collectedAt != null;
    }

    public boolean isUncollected() {
        return !this.isCollected();
    }

    public boolean isReported() {
        return this.reportedAt != null;
    }

    public boolean markAsCollected() {
        if (this.isCollected()) {
            return false;
        }
        this.collectedAt = this.updatedAt = LocalDateTime.now();
        return true;
    }

    public boolean markAsReported() {
        if (this.isReported()) {
            return false;
        }
        this.reportedAt = this.updatedAt = LocalDateTime.now();
        return true;
    }

    public void transfer(Customer customer) {
        this.customer = customer;
        this.updatedAt = LocalDateTime.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return this.id == payment.id && this.serverId == payment.serverId && Objects.equals(this.customer, payment.customer) && Objects.equals(this.collectedAt, payment.collectedAt) && Objects.equals(this.reportedAt, payment.reportedAt) && Objects.equals(this.createdAt, payment.createdAt) && Objects.equals(this.updatedAt, payment.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.customer, this.serverId, this.id, this.collectedAt, this.reportedAt, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "Payment{id=" + this.id + ", customer=" + this.customer + ", serverId=" + this.serverId + ", purchases=" + this.getPurchasesAmount() + ", collectedAt=" + this.collectedAt + ", reportedAt=" + this.reportedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public Customer getCustomer() {
        return this.customer;
    }

    @Generated
    public int getServerId() {
        return this.serverId;
    }

    @Generated
    public LocalDateTime getCollectedAt() {
        return this.collectedAt;
    }

    @Generated
    public LocalDateTime getReportedAt() {
        return this.reportedAt;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ForeignCollection<Purchase> getPurchases() {
        return this.purchases;
    }

    @Generated
    public Payment() {
    }
}

