/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.model;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.database.model.Payment;
import ru.easydonate.easypayments.libs.ormlite.dao.ForeignCollection;
import ru.easydonate.easypayments.libs.ormlite.field.DatabaseField;
import ru.easydonate.easypayments.libs.ormlite.field.ForeignCollectionField;
import ru.easydonate.easypayments.libs.ormlite.table.DatabaseTable;

@DatabaseTable(tableName="easypayments_customers")
public final class Customer {
    public static final String COLUMN_PLAYER_NAME = "player_name";
    public static final String COLUMN_PLAYER_UUID = "player_uuid";
    public static final String COLUMN_CREATED_AT = "created_at";
    public static final String COLUMN_UPDATED_AT = "updated_at";
    @DatabaseField(columnName="player_name", id=true)
    private String playerName;
    @DatabaseField(columnName="player_uuid", canBeNull=false)
    private UUID playerUUID;
    @DatabaseField(columnName="created_at", canBeNull=false)
    private LocalDateTime createdAt;
    @DatabaseField(columnName="updated_at", canBeNull=false)
    private LocalDateTime updatedAt;
    @ForeignCollectionField
    private ForeignCollection<Payment> payments;

    public Customer(@NotNull OfflinePlayer bukkitPlayer) {
        this(bukkitPlayer.getName(), bukkitPlayer.getUniqueId());
    }

    public Customer(@NotNull String playerName, @NotNull UUID playerUUID) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.updatedAt = this.createdAt = LocalDateTime.now();
    }

    @NotNull
    public Payment createPayment(int paymentId, int serverId) {
        return new Payment(this, paymentId, serverId);
    }

    @NotNull
    public OfflinePlayer asBukkitPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.playerUUID);
    }

    public int getPaymentsAmount() {
        return this.payments != null ? this.payments.size() : 0;
    }

    public void updateUUID(@NotNull UUID uuid) {
        this.playerUUID = uuid;
        this.onUpdate();
    }

    private void onUpdate() {
        this.updatedAt = LocalDateTime.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return Objects.equals(this.playerName, customer.playerName) && Objects.equals(this.playerUUID, customer.playerUUID) && Objects.equals(this.createdAt, customer.createdAt) && Objects.equals(this.updatedAt, customer.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.playerName, this.playerUUID, this.createdAt, this.updatedAt);
    }

    @NotNull
    public String toString() {
        return "Customer{playerName='" + this.playerName + '\'' + ", playerUUID=" + this.playerUUID + ", payments=" + this.getPaymentsAmount() + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ForeignCollection<Payment> getPayments() {
        return this.payments;
    }

    @Generated
    public Customer() {
    }
}

