/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database.credentials;

import java.sql.SQLException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.AuthDatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentialsParser;
import ru.easydonate.easypayments.database.credentials.local.LocalDatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.remote.RemoteDatabaseCredentials;
import ru.easydonate.easypayments.exception.CredentialsParseException;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;

public interface DatabaseCredentials {
    @NotNull
    public static DatabaseCredentials parse(@NotNull Plugin plugin, @NotNull ConfigurationSection config, @NotNull DatabaseType databaseType) throws CredentialsParseException {
        return DatabaseCredentialsParser.parse(plugin, config, databaseType);
    }

    @NotNull
    public DatabaseType getDatabaseType();

    @NotNull
    public String getConnectionUrl();

    @NotNull
    public ConnectionSource getConnectionSource() throws SQLException;

    public void loadDriver(@NotNull Plugin var1) throws DriverNotFoundException, DriverLoadException;

    default public boolean isAuthRequired() {
        return this instanceof AuthDatabaseCredentials;
    }

    default public boolean isLocalDatabase() {
        return this instanceof LocalDatabaseCredentials;
    }

    default public boolean isRemoteDatabase() {
        return this instanceof RemoteDatabaseCredentials;
    }
}

