/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.database;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.config.Configuration;
import ru.easydonate.easypayments.database.DatabaseType;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentials;
import ru.easydonate.easypayments.database.credentials.DatabaseCredentialsParser;
import ru.easydonate.easypayments.exception.CredentialsParseException;
import ru.easydonate.easypayments.exception.DriverLoadException;
import ru.easydonate.easypayments.exception.DriverNotFoundException;
import ru.easydonate.easypayments.libs.ormlite.field.DataPersister;
import ru.easydonate.easypayments.libs.ormlite.field.DataPersisterManager;
import ru.easydonate.easypayments.libs.ormlite.support.ConnectionSource;
import ru.easydonate.easypayments.libs.ormlite.table.TableUtils;

public final class Database {
    private final DatabaseType databaseType;
    private final DatabaseCredentials databaseCredentials;
    private final ConnectionSource bootstrapConnection;
    private final Set<Class<?>> registeredTables = new LinkedHashSet();

    public Database(@NotNull Plugin plugin, @NotNull Configuration config) throws CredentialsParseException, DriverNotFoundException, DriverLoadException, SQLException {
        this(plugin, config, Database.parseDatabaseType(config));
    }

    public Database(@NotNull Plugin plugin, @NotNull Configuration config, @NotNull DatabaseType databaseType) throws CredentialsParseException, DriverNotFoundException, DriverLoadException, SQLException {
        this.databaseType = databaseType;
        ConfigurationSection credentialsConfig = config.getSection("database." + databaseType.getKey());
        this.databaseCredentials = DatabaseCredentialsParser.parse(plugin, credentialsConfig, databaseType);
        this.databaseCredentials.loadDriver(plugin);
        this.bootstrapConnection = this.establishConnection();
    }

    @NotNull
    private static DatabaseType parseDatabaseType(@NotNull Configuration config) throws IllegalArgumentException {
        String rawType = config.getString("database.type", "");
        DatabaseType databaseType = DatabaseType.getByKey(rawType);
        if (databaseType.isUnknown()) {
            throw new IllegalArgumentException(String.format("Unknown database type '%s'!", rawType));
        }
        return databaseType;
    }

    @NotNull
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @NotNull
    public ConnectionSource getBootstrapConnection() {
        if (this.bootstrapConnection == null) {
            throw new IllegalStateException("The database instance wasn't initialized correctly!");
        }
        return this.bootstrapConnection;
    }

    @NotNull
    public ConnectionSource establishConnection() throws SQLException {
        return this.databaseCredentials.getConnectionSource();
    }

    @NotNull
    public Database complete() throws SQLException {
        ConnectionSource bootstrapConnection = this.getBootstrapConnection();
        if (!this.registeredTables.isEmpty()) {
            for (Class<?> registeredTable : this.registeredTables) {
                TableUtils.createTableIfNotExists(bootstrapConnection, registeredTable);
            }
        }
        bootstrapConnection.closeQuietly();
        return this;
    }

    @NotNull
    public Database registerTable(@NotNull Class<?> tableClass) {
        this.registeredTables.add(tableClass);
        return this;
    }

    @NotNull
    public Database registerTables(Class<?> ... tableClasses) {
        if (tableClasses != null && tableClasses.length != 0) {
            this.registeredTables.addAll(Arrays.asList(tableClasses));
        }
        return this;
    }

    @NotNull
    public Database registerPersister(@NotNull DataPersister dataPersister) {
        DataPersisterManager.registerDataPersisters(dataPersister);
        return this;
    }

    @Generated
    public DatabaseCredentials getDatabaseCredentials() {
        return this.databaseCredentials;
    }

    @Generated
    public Set<Class<?>> getRegisteredTables() {
        return this.registeredTables;
    }
}

