/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.util;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class ThreadLocker {
    public static void lockUninterruptive(long duration, @NotNull TimeUnit timeUnit) {
        ThreadLocker.lockUninterruptive(timeUnit.toMillis(duration));
    }

    public static void lockUninterruptive(long timeInMillis) {
        ThreadLocker.doUninterruptive(() -> Thread.sleep(timeInMillis));
    }

    public static void doUninterruptive(Action action) {
        try {
            action.perform();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Generated
    private ThreadLocker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface Action {
        public void perform() throws InterruptedException;
    }
}

