/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.util;

import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedWrapper<T>
implements Comparable<IndexedWrapper<T>> {
    protected final int index;
    protected T object;

    public IndexedWrapper(int index) {
        this(index, null);
    }

    public IndexedWrapper(int index, @Nullable T object) {
        this.index = index;
        this.object = object;
    }

    @NotNull
    public <O> IndexedWrapper<O> map(@NotNull Function<T, O> mapper) {
        T mappedObject = this.object != null ? (T)mapper.apply(this.object) : null;
        return new IndexedWrapper<Object>(this.index, mappedObject);
    }

    @NotNull
    public IndexedWrapper<T> setObject(@Nullable T object) {
        this.object = object;
        return this;
    }

    @Override
    public int compareTo(@NotNull IndexedWrapper<T> o) {
        return Integer.compare(this.index, o.index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedWrapper that = (IndexedWrapper)o;
        return this.index == that.index && Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.object);
    }

    @NotNull
    public String toString() {
        return "IndexedWrapper{index=" + this.index + ", object=" + this.object + '}';
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public T getObject() {
        return this.object;
    }
}

