/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import ru.easydonate.easypayments.core.util.DeletingFileVisitor;

public final class FileBackupMaker {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("ddMMyyyy-HHmmss");

    public static Path createFileBackup(Path filePath) throws IOException {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return null;
        }
        Path backupPath = FileBackupMaker.getBackupPath(filePath);
        if (Files.isDirectory(backupPath, new LinkOption[0])) {
            Files.walkFileTree(backupPath, new DeletingFileVisitor());
        }
        Files.copy(filePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        return backupPath;
    }

    public static Path getBackupPath(Path originalPath) {
        Path parentDir = originalPath.getParent();
        String name = originalPath.getFileName().toString();
        String timestamp = LocalDateTime.now(ZoneOffset.UTC).format(DATE_TIME_FORMATTER);
        return parentDir.resolve(name + '@' + timestamp + ".bak");
    }

    @Generated
    private FileBackupMaker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

