/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.util;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import lombok.Generated;

public final class ChecksumSupplier {
    private static final char[] HEX_CODE = "0123456789abcdef".toCharArray();

    public static byte[] computeChecksum(Path path) throws Exception {
        try (InputStream dataStream = Files.newInputStream(path, new OpenOption[0]);){
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest digest = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = dataStream.read(buffer)) <= 0) continue;
                digest.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = digest.digest();
            return byArray;
        }
    }

    public static String getChecksumAsString(Path path) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(Files.readAllBytes(path));
        byte[] digest = messageDigest.digest();
        return ChecksumSupplier.printHexBinary(digest).toUpperCase();
    }

    private static String printHexBinary(byte[] data) {
        StringBuilder builder = new StringBuilder(data.length * 2);
        for (byte b : data) {
            builder.append(HEX_CODE[b >> 4 & 0xF]).append(HEX_CODE[b & 0xF]);
        }
        return builder.toString();
    }

    @Generated
    private ChecksumSupplier() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

