/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.platform.provider;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.config.Configuration;

public final class PlatformResolverState {
    @NotNull
    public static final String DEFAULT_EXECUTOR_NAME = "@EasyPayments";
    public static final boolean DEFAULT_FORCE_INTERNALS = false;
    public static final int DEFAULT_PERMISSION_LEVEL = 4;
    @NotNull
    public static final PlatformResolverState DEFAULT = new PlatformResolverState("@EasyPayments", false, 4);
    @NotNull
    private final String executorName;
    private final boolean forceInternals;
    private final int permissionLevel;

    @NotNull
    public static PlatformResolverState from(@NotNull Configuration config) {
        return PlatformResolverState.builder().executorName(config.getString("executor-name", DEFAULT_EXECUTOR_NAME)).forceInternals(config.getBoolean("force-internals-backed-platform", false)).permissionLevel(config.getIntWithBounds("permission-level", 0, 4, 4)).build();
    }

    public boolean requiresPlatformResolve(@NotNull PlatformResolverState other) {
        return this.forceInternals != other.forceInternals;
    }

    public boolean requiresPlatformUpdate(@NotNull PlatformResolverState other) {
        return !Objects.equals(this.executorName, other.executorName) || this.permissionLevel != other.permissionLevel;
    }

    @Generated
    private static PlatformResolverStateBuilder builder() {
        return new PlatformResolverStateBuilder();
    }

    @NotNull
    @Generated
    public String getExecutorName() {
        return this.executorName;
    }

    @Generated
    public boolean isForceInternals() {
        return this.forceInternals;
    }

    @Generated
    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformResolverState)) {
            return false;
        }
        PlatformResolverState other = (PlatformResolverState)o;
        if (this.isForceInternals() != other.isForceInternals()) {
            return false;
        }
        if (this.getPermissionLevel() != other.getPermissionLevel()) {
            return false;
        }
        String this$executorName = this.getExecutorName();
        String other$executorName = other.getExecutorName();
        return !(this$executorName == null ? other$executorName != null : !this$executorName.equals(other$executorName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceInternals() ? 79 : 97);
        result = result * 59 + this.getPermissionLevel();
        String $executorName = this.getExecutorName();
        result = result * 59 + ($executorName == null ? 43 : $executorName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PlatformResolverState(executorName=" + this.getExecutorName() + ", forceInternals=" + this.isForceInternals() + ", permissionLevel=" + this.getPermissionLevel() + ")";
    }

    @Generated
    private PlatformResolverState(@NotNull String executorName, boolean forceInternals, int permissionLevel) {
        if (executorName == null) {
            throw new NullPointerException("executorName is marked non-null but is null");
        }
        this.executorName = executorName;
        this.forceInternals = forceInternals;
        this.permissionLevel = permissionLevel;
    }

    @Generated
    private static class PlatformResolverStateBuilder {
        @Generated
        private String executorName;
        @Generated
        private boolean forceInternals;
        @Generated
        private int permissionLevel;

        @Generated
        PlatformResolverStateBuilder() {
        }

        @Generated
        private PlatformResolverStateBuilder executorName(@NotNull String executorName) {
            if (executorName == null) {
                throw new NullPointerException("executorName is marked non-null but is null");
            }
            this.executorName = executorName;
            return this;
        }

        @Generated
        private PlatformResolverStateBuilder forceInternals(boolean forceInternals) {
            this.forceInternals = forceInternals;
            return this;
        }

        @Generated
        private PlatformResolverStateBuilder permissionLevel(int permissionLevel) {
            this.permissionLevel = permissionLevel;
            return this;
        }

        @Generated
        private PlatformResolverState build() {
            return new PlatformResolverState(this.executorName, this.forceInternals, this.permissionLevel);
        }

        @Generated
        public String toString() {
            return "PlatformResolverState.PlatformResolverStateBuilder(executorName=" + this.executorName + ", forceInternals=" + this.forceInternals + ", permissionLevel=" + this.permissionLevel + ")";
        }
    }
}

