/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.platform.provider;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.platform.provider.PlatformProvider;
import ru.easydonate.easypayments.core.platform.provider.PlatformResolverState;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;

public abstract class PlatformProviderBase
implements PlatformProvider {
    @NotNull
    protected final EasyPayments plugin;
    @NotNull
    protected final PlatformScheduler scheduler;
    @NotNull
    protected final Executor syncExecutor;
    @NotNull
    protected String executorName;
    protected int permissionLevel;
    @NotNull
    protected InterceptorFactory interceptorFactory;

    public PlatformProviderBase(@NotNull EasyPayments plugin, @NotNull PlatformScheduler scheduler, @NotNull String executorName, int permissionLevel) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.syncExecutor = task -> scheduler.runSyncNow(plugin, task);
        this.executorName = executorName;
        this.permissionLevel = permissionLevel;
        this.interceptorFactory = this.createInterceptorFactory();
    }

    @NotNull
    protected abstract InterceptorFactory createInterceptorFactory();

    @NotNull
    protected abstract UUID resolveOfflinePlayerId(@NotNull String var1);

    @Override
    @NotNull
    public UUID resolvePlayerId(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name cannot be empty");
        return this.findOnlinePlayer(name).map(OfflinePlayer::getUniqueId).orElseGet(() -> this.findOfflinePlayer(name).map(OfflinePlayer::getUniqueId).orElseGet(() -> {
            try {
                return this.resolveOfflinePlayerId(name);
            }
            catch (Exception ex) {
                this.plugin.getDebugLogger().error("Couldn't resolve offline player UUID for '{0}'", name);
                this.plugin.getDebugLogger().error(ex);
                return this.generateOfflinePlayerId(name);
            }
        }));
    }

    @Override
    public boolean isTaskCancelled(@NotNull BukkitTask bukkitTask) {
        return bukkitTask.isCancelled();
    }

    public final void updateInterceptorFactory(@NotNull PlatformResolverState state) {
        this.updateInterceptorFactory(state.getExecutorName(), state.getPermissionLevel());
    }

    public final synchronized void updateInterceptorFactory(@NotNull String executorName, int permissionLevel) {
        if (Objects.equals(this.executorName, executorName) && this.permissionLevel == permissionLevel) {
            return;
        }
        this.executorName = executorName;
        this.permissionLevel = permissionLevel;
        this.interceptorFactory = this.createInterceptorFactory();
    }

    @NotNull
    protected final UUID generateOfflinePlayerId(@NotNull String name) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8));
    }

    @NotNull
    private Optional<Player> findOnlinePlayer(@NotNull String name) {
        for (Player candidate : this.plugin.getServer().getOnlinePlayers()) {
            if (!name.equals(candidate.getName())) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<OfflinePlayer> findOfflinePlayer(@NotNull String name) {
        for (OfflinePlayer candidate : this.plugin.getServer().getOfflinePlayers()) {
            if (!name.equals(candidate.getName())) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    @Generated
    public EasyPayments getPlugin() {
        return this.plugin;
    }

    @Override
    @NotNull
    @Generated
    public PlatformScheduler getScheduler() {
        return this.scheduler;
    }

    @NotNull
    @Generated
    public Executor getSyncExecutor() {
        return this.syncExecutor;
    }

    @Override
    @NotNull
    @Generated
    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }
}

