/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.platform.provider;

import java.util.UUID;
import lombok.Generated;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.EasyPayments;
import ru.easydonate.easypayments.core.interceptor.InterceptorFactory;
import ru.easydonate.easypayments.core.platform.scheduler.PlatformScheduler;

public interface PlatformProvider {
    @NotNull
    public String getProviderId();

    @NotNull
    public EasyPayments getPlugin();

    @NotNull
    public ImplementationType getImplementationType();

    @NotNull
    public PlatformType getPlatformType();

    @NotNull
    public PlatformScheduler getScheduler();

    @NotNull
    public InterceptorFactory getInterceptorFactory();

    @NotNull
    public UUID resolvePlayerId(@NotNull String var1);

    public boolean isTaskCancelled(@NotNull BukkitTask var1);

    @NotNull
    default public String getDisplayName() {
        return this.getPlatformType().getName() + ' ' + this.getImplementationType().getName();
    }

    public static enum PlatformType {
        SPIGOT("spigot", "Spigot"),
        PAPER("paper", "Paper"),
        FOLIA("folia", "Folia");

        @NotNull
        private final String key;
        @NotNull
        private final String name;

        @NotNull
        public static PlatformType with(boolean runningFolia) {
            return runningFolia ? FOLIA : PAPER;
        }

        @NotNull
        @Generated
        public String getKey() {
            return this.key;
        }

        @NotNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private PlatformType(String key, String name) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.key = key;
            this.name = name;
        }
    }

    public static enum ImplementationType {
        INTERNALS("internals", "Internals"),
        UNIVERSAL("universal", "Universal");

        @NotNull
        private final String key;
        @NotNull
        private final String name;

        @NotNull
        @Generated
        public String getKey() {
            return this.key;
        }

        @NotNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        private ImplementationType(String key, String name) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.key = key;
            this.name = name;
        }
    }
}

