/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.placeholder;

import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.easydonate.easypayments.core.placeholder.PlaceholderReplacer;
import ru.easydonate.easypayments.core.placeholder.StringContainer;

public final class PlaceholderReplacerBus {
    private final Set<PlaceholderReplacer> replacers = new LinkedHashSet<PlaceholderReplacer>();

    @NotNull
    public StringContainer processPlaceholders(@NotNull Player bukkitPlayer, @NotNull StringContainer container) {
        if (!this.replacers.isEmpty() && container.isSupportingPlaceholders()) {
            for (PlaceholderReplacer replacer : this.replacers) {
                replacer.replace(bukkitPlayer, container);
            }
        }
        return container;
    }

    @NotNull
    public PlaceholderReplacerBus addReplacer(@NotNull PlaceholderReplacer replacer) {
        this.replacers.add(replacer);
        return this;
    }

    @NotNull
    public PlaceholderReplacerBus removeReplacer(@NotNull PlaceholderReplacer replacer) {
        this.replacers.remove(replacer);
        return this;
    }
}

