/*
 * Decompiled with CFR 0.152.
 */
package ru.easydonate.easypayments.core.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.bukkit.plugin.Plugin;
import ru.easydonate.easypayments.core.logging.DebugEnvironmentLookup;

public final class DebugLogger {
    static final DateTimeFormatter LOG_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yy HH:mm:ss");
    private static final char LEVEL_DEBUG = 'D';
    private static final char LEVEL_INFO = 'I';
    private static final char LEVEL_WARN = 'W';
    private static final char LEVEL_ERROR = 'E';
    private final Path logsDir;
    private final Path logFile;
    private volatile boolean working;

    public DebugLogger(Plugin plugin) {
        this.logsDir = plugin.getDataFolder().toPath().resolve("logs");
        this.logFile = DebugLogger.findFreeFileName(this.logsDir);
        this.working = true;
        this.compressLogFiles();
        DebugEnvironmentLookup.writeEnvironmentInfo(plugin, this);
    }

    public void cleanLogsDir(int timeToLife) {
        if (timeToLife < 0 || !Files.isDirectory(this.logsDir, new LinkOption[0])) {
            return;
        }
        LocalDate minFileNameDate = LocalDate.now(ZoneOffset.UTC).minusDays(timeToLife);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.logsDir, "debug-*.log.gz");){
            for (Path path : dirStream) {
                try {
                    LocalDate fileNameDate;
                    String rawFileNameDate;
                    String fileName;
                    int lastHyphenIndex;
                    if (!Files.isRegularFile(path, new LinkOption[0]) || (lastHyphenIndex = (fileName = path.getFileName().toString()).lastIndexOf(45)) == -1 || (rawFileNameDate = fileName.substring(6, lastHyphenIndex)).length() != 10 || !(fileNameDate = LocalDate.parse(rawFileNameDate, DateTimeFormatter.ISO_LOCAL_DATE)).isBefore(minFileNameDate)) continue;
                    Files.deleteIfExists(path);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void compressLogFiles() {
        if (!Files.isDirectory(this.logsDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.logsDir, "debug-*.log");){
            dirStream.forEach(this::compressLogFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.working = false;
        this.compressLogFile(this.logFile);
    }

    public DebugLogger debug(String message, Object ... args) {
        return this.logMessage('D', message, args);
    }

    public DebugLogger debug(String[] messages) {
        return this.log('D', messages);
    }

    public DebugLogger info(String message, Object ... args) {
        return this.logMessage('I', message, args);
    }

    public DebugLogger info(String[] messages) {
        return this.log('I', messages);
    }

    public DebugLogger warn(String message, Object ... args) {
        return this.logMessage('W', message, args);
    }

    public DebugLogger warn(String[] messages) {
        return this.log('W', messages);
    }

    public DebugLogger error(String message, Object ... args) {
        return this.logMessage('E', message, args);
    }

    public DebugLogger error(String[] messages) {
        return this.log('E', messages);
    }

    public DebugLogger debug(Throwable throwable) {
        return this.logStacktrace('D', throwable);
    }

    public DebugLogger info(Throwable throwable) {
        return this.logStacktrace('I', throwable);
    }

    public DebugLogger warn(Throwable throwable) {
        return this.logStacktrace('W', throwable);
    }

    public DebugLogger error(Throwable throwable) {
        return this.logStacktrace('E', throwable);
    }

    private DebugLogger logMessage(char level, String message, Object ... args) {
        if (!this.working) {
            return this;
        }
        message = args != null && args.length != 0 ? MessageFormat.format(message.replace("'", "''"), args) : message;
        return this.log(level, message);
    }

    private DebugLogger logStacktrace(char level, Throwable throwable) {
        if (!this.working) {
            return this;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return this.log(level, stringWriter.toString().split("\n"));
    }

    private synchronized DebugLogger log(char level, String ... content) {
        if (!this.working) {
            return this;
        }
        String timestamp = LOG_TIMESTAMP_FORMATTER.format(LocalDateTime.now(ZoneOffset.UTC));
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : content) {
            if (line == null || line.isEmpty()) continue;
            lines.add('[' + timestamp + "] [" + level + "] " + line);
        }
        if (!lines.isEmpty()) {
            this.writeToFile(lines);
        }
        return this;
    }

    synchronized void writeToFile(List<String> content) {
        if (!this.working) {
            return;
        }
        if (!Files.isDirectory(this.logFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(this.logFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException ignored) {
                return;
            }
        }
        try {
            Files.write(this.logFile, content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void compressLogFile(Path filePath) {
        if (this.working && filePath.getFileName().equals(this.logFile.getFileName())) {
            return;
        }
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            return;
        }
        Path compressedFile = filePath.getParent().resolve(filePath.getFileName() + ".gz");
        try (InputStream sourceStream = Files.newInputStream(filePath, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(compressedFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
            int read;
            byte[] buffer = new byte[1024];
            do {
                if ((read = sourceStream.read(buffer)) <= 0) continue;
                gzipOutputStream.write(buffer, 0, read);
            } while (read > 0);
            gzipOutputStream.flush();
        }
        catch (IOException ignored) {
            return;
        }
        try {
            Files.deleteIfExists(filePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path findFreeFileName(Path directory) {
        String timestamp = DateTimeFormatter.ISO_LOCAL_DATE.format(LocalDate.now(ZoneOffset.UTC));
        String baseName = "debug-" + timestamp;
        int logNumber = 1;
        if (Files.isDirectory(directory, new LinkOption[0])) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory, baseName + "-*.{log,log.gz}");){
                for (Path path : dirStream) {
                    if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                    String fileName = path.getFileName().toString();
                    int dotIndex = fileName.indexOf(".");
                    try {
                        int logFileNumber = Integer.parseInt(fileName.substring(17, dotIndex));
                        if (logFileNumber < logNumber) continue;
                        logNumber = logFileNumber + 1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return directory.resolve(baseName + "-" + logNumber + ".log");
    }
}

